/**
 * @author Juan Manuel Amador Olivares (virtualmech)
 */
#ifndef GUARDAROTRONOMBRE_H
#define GUARDAROTRONOMBRE_H

#include "Mensaje.h"
#include "SistemaArchivos.h"
#include "MSCFileSystem.h"
#include "ScreenManager.h"
#include "FechaHora.h"
#include "Teclado.h"

// Lista de elementos seleccionables. Tamaño de caracteres 8. 
class GuardarOtroNombre: public Mensaje{
    public:
    GuardarOtroNombre(char nextScreen[], char newAdvice[], char newWaitMsg[]);
    
    virtual void initialize(DogMLCD* lcd);
    
    virtual void button5pressed(DogMLCD* lcd);
    
    void setNombreAntiguo(char *oldName);     // Configura el nombre antiguo del archivo al que se le va a cambiar el nombre
                                                // si vale NULL se considera que el nombre antiguo es el guardado por el sistema de fecha y hora (nombres por defecto)
    void disableNombreAntiguo();            // Pone nombre antiguo a NULL
    
    private:
    
    char *nombreAntiguo;
    char waitMsg[MAXCARACTER];
};

#endif