#include "mbed.h"
#include "MSCFileSystem.h"
#include "Configuracion.h"
#include "SistemaArchivos.h"
#include "FechaHora.h"
#include "SelecManager.h"
#include "ScreenManager.h"
#include "Portada.cpp"
#include "Menu.h"
#include "ListaSelec.h"
#include "IdiomaSelec.h"
#include "FormaSelec.h"
#include "VelAdquisicionSel.h"
#include "RestaurarValores.h"
#include "Mensaje.h"
#include "NuevoViaje.h"
#include "GuardarViaje.h"
#include "ArchivoGuardado.h"
#include "ViajesGuardados.h"
#include "Teclado.h"
#include "GuardarOtroNombre.h"
#include "OpcionesViaje.h"
#include "FechaHoraConf.h"
#include "AutoCalibracion.h"

//DEFINICIONES
#define ESPANOL 0
#define INGLES 1

/// PEN DRIVE ///
MSCFileSystem msc("usb");

/// MEMORIA FLASH LOCAL DE LA MBED ///
LocalFileSystem local("local");               // Create the local filesystem under the name "local"
Configuracion config = Configuracion();
SistemaArchivos SA = SistemaArchivos();

// Fecha y hora
FechaHora FH;

/********************************************
        PANTALLAS
 ********************************************/
SPI     spi( p5, NC, p7 ); // MOSI, MISO, CLK
DogMLCD dog( spi, p10, p8); // SPI, CS, A0

ScreenManager SC(&dog); // Screen Manager
SelecManager SM;  // gestiona las pantallas que tienen elementos seleccionables

Portada portadaVm = Portada();
Screen* pportadaVm = &portadaVm;

Menu menu = Menu();
Screen* pmenu = &menu;
Seleccion* psmenu = &menu;

Teclado keyboard = Teclado();
Screen* pkeyboard = &keyboard;
Seleccion* pskeyboard = &keyboard;

ViajesGuardados listaViajes = ViajesGuardados("No existen viajes"); 
Screen* plistaViajes = &listaViajes;
Seleccion* pslistaViajes = &listaViajes;

ListaSelec configuracion = ListaSelec();
Screen* pconfiguracion = &configuracion;
Seleccion* psconfiguracion = &configuracion;

RestaurarValores restaurar = RestaurarValores("\250Est\240 seguro?");
Screen* prestaurar = &restaurar;
Seleccion*  psrestaurar = &restaurar;

IdiomaSelec idioma = IdiomaSelec();
Screen* pidioma = &idioma;
Seleccion* psidioma = &idioma;

FormaSelec formaSelec = FormaSelec();
Screen* pformaSelec = &formaSelec;
Seleccion* psformaSelec = &formaSelec;

VelAdquisicionSel velAdquisionSel = VelAdquisicionSel();
Screen* pvelAdquisionSel = &velAdquisionSel;
Seleccion* psvelAdquisionSel = &velAdquisionSel;

NuevoViaje nuevoViaje = NuevoViaje("Adquiriendo datos", "Frecuencia: ", "OK para comenzar.", "OK para finalizar.", "Pulse atr\240s para cancelar.");
Screen* pnuevoViaje = &nuevoViaje;

Mensaje noUSB = Mensaje("menu", "Pulse OK para volver.");
Screen* pnoUSB = &noUSB;

GuardarOtroNombre guardadoCorrect = GuardarOtroNombre("menu", "Pulse OK para continuar.", "Espere por favor"); //warten sie bitte
Screen* pguardadoCorrect = &guardadoCorrect;

GuardarViaje guardaViaje = GuardarViaje();
Screen* pguardaViaje = &guardaViaje;
Seleccion* psguardaViaje = &guardaViaje;

OpcionesViaje opcionesViaje = OpcionesViaje();
Screen* popcionesViaje = &opcionesViaje;
Seleccion* psopcionesViaje = &opcionesViaje;

ArchivoGuardado archivoGuardado = ArchivoGuardado("guardaViaje", "Pulse OK para continuar.", "Archivo guardado:", "Fecha:", "Hora:");
Screen* parchivoGuardado = &archivoGuardado;

Mensaje archivoBorrado = Mensaje("menu", "Pulse OK para continuar.");
Screen* parchivoBorrado = &archivoBorrado;

Mensaje nombreExistente = Mensaje("guardaViaje", "Pulse OK para volver.");
Screen* pnombreExistente = &nombreExistente;

FechaHoraConf fechaHoraConf = FechaHoraConf("Pulse las teclas arriba y", "abajo para cambiar los", "valores.", "Fecha:", "Hora:");
Screen* pfechaHoraConf = &fechaHoraConf;
Seleccion* psfechaHoraConf = &fechaHoraConf;

AutoCalibracion calibrando = AutoCalibracion();
Screen* pcalibrando = &calibrando;

// Inglés
Menu menuEN = Menu();
Screen* pmenuEN = &menuEN;
Seleccion* psmenuEN = &menuEN;

ViajesGuardados listaViajesEN = ViajesGuardados("No travels");
Screen* plistaViajesEN = &listaViajesEN;
Seleccion* pslistaViajesEN = &listaViajesEN;

ListaSelec configuracionEN = ListaSelec();
Screen* pconfiguracionEN = &configuracionEN;
Seleccion* psconfiguracionEN = &configuracionEN;

RestaurarValores restaurarEN = RestaurarValores("Are you sure?");
Screen* prestaurarEN = &restaurarEN;
Seleccion*  psrestaurarEN = &restaurarEN;

IdiomaSelec idiomaEN = IdiomaSelec();
Screen* pidiomaEN = &idiomaEN;
Seleccion* psidiomaEN = &idiomaEN;

FormaSelec formaSelecEN = FormaSelec();
Screen* pformaSelecEN = &formaSelecEN;
Seleccion* psformaSelecEN = &formaSelecEN;

NuevoViaje nuevoViajeEN = NuevoViaje("Acquiring data", "Frecuency: ", "Press OK to start.", "Press OK to finish.", "Press back to cancel.");
Screen* pnuevoViajeEN = &nuevoViajeEN;

Mensaje noUSBEN = Mensaje("menu", "Press OK to back.");
Screen* pnoUSBEN = &noUSBEN;

GuardarOtroNombre guardadoCorrectEN = GuardarOtroNombre("menu", "Press OK to continue.", "Please wait");
Screen* pguardadoCorrectEN = &guardadoCorrectEN;

GuardarViaje guardaViajeEN = GuardarViaje();
Screen* pguardaViajeEN = &guardaViajeEN;
Seleccion* psguardaViajeEN = &guardaViajeEN;

OpcionesViaje opcionesViajeEN = OpcionesViaje();
Screen* popcionesViajeEN = &opcionesViajeEN;
Seleccion* psopcionesViajeEN = &opcionesViajeEN;

ArchivoGuardado archivoGuardadoEN = ArchivoGuardado("guardaViaje", "Press OK to continue.", "Saved file:", "date:", "Time:");
Screen* parchivoGuardadoEN = &archivoGuardadoEN;

Mensaje archivoBorradoEN = Mensaje("menu", "Press OK to continue.");
Screen* parchivoBorradoEN = &archivoBorradoEN;

Mensaje nombreExistenteEN = Mensaje("guardaViaje", "Press OK to back.");
Screen* pnombreExistenteEN = &nombreExistenteEN;

FechaHoraConf fechaHoraConfEN = FechaHoraConf("Press the up and down keys to change values.", "", "", "Date:", "Time:");
Screen* pfechaHoraConfEN = &fechaHoraConfEN;
Seleccion* psfechaHoraConfEN = &fechaHoraConfEN;

/********************************************/

/********************************************
    BOTONES
 ********************************************/
DigitalIn boton1(p30);
DigitalIn boton2(p29);
DigitalIn boton3(p28);
DigitalIn boton4(p27);
DigitalIn boton5(p26);
DigitalIn boton6(p14);
/********************************************/

DigitalOut myled(LED2);

Timer t;

int main() 
{   
    /********************************************
        PANTALLAS
    ********************************************/
    /******************* Se añaden las pantallas al ScreenManager ******************************/
    
    // Portada inicial
    SC.addScreen(pportadaVm, "portada", ESPANOL);
    SC.addScreen(pportadaVm, "portada", INGLES);
    
    // Menu principal
    menu.addElement("Nuevo viaje", "viaje");
    menu.addElement("Viajes guardados", "listadoViajes");
    menu.addElement("Configuraci\242n", "configuracion");
    menu.setSelect(0);
    SC.addScreen(pmenu, "menu", ESPANOL);
    SM.addScreen(psmenu);
    
    menuEN.addElement("New ride", "viaje");
    menuEN.addElement("Saved rides", "listadoViajes");
    menuEN.addElement("Settings", "configuracion");
    menuEN.setSelect(0);
    SC.addScreen(pmenuEN, "menu", INGLES);
    SM.addScreen(psmenuEN);
    
    // Pantalla teclado
    keyboard.setSelect(0);
    SC.addScreen(pkeyboard, "teclado", ESPANOL);    // El teclado es el mismo para todos los idiomas
    SC.addScreen(pkeyboard, "teclado", INGLES);
    SM.addScreen(pskeyboard);
    
    // Pantalla de autocalibración
    SC.addScreen(pcalibrando, "calibrate", ESPANOL);    // La pantalla de calibración es la misma para todos los idiomas (el idioma se controla en el propio código de la pantalla)
    SC.addScreen(pcalibrando, "calibrate", INGLES);
    
    // Lista de viajes guardados
    listaViajes.setBackScreen("menu");
    SC.addScreen(plistaViajes, "listadoViajes", ESPANOL);
    SM.addScreen(pslistaViajes);
    
    listaViajesEN.setBackScreen("menu");
    SC.addScreen(plistaViajesEN, "listadoViajes", INGLES);
    SM.addScreen(pslistaViajesEN);
    
    // Lista de configuración
    configuracion.addElement("Velocidad de adquisici\242n", "velAdquisionSel");
    configuracion.addElement("Idioma", "idioma");
    configuracion.addElement("Visualizaci\242n", "formaSelec");
    configuracion.addElement("Ajustar fecha y hora", "confFecha");
    configuracion.addElement("Autocalibraci\242n", "calibrate");
    configuracion.addElement("Valores de f\240brica", "restaurar");
    configuracion.setBackScreen("menu");
    SC.addScreen(pconfiguracion, "configuracion", 0);
    SM.addScreen(psconfiguracion);
    
    configuracionEN.addElement("Sample Rate", "velAdquisionSel");
    configuracionEN.addElement("Languaje", "idioma");
    configuracionEN.addElement("Visualization", "formaSelec");
    configuracionEN.addElement("Set date and time", "confFecha");
    configuracionEN.addElement("Autocalibration", "calibrate");
    configuracionEN.addElement("Restore default settings", "restaurar");
    configuracionEN.setBackScreen("menu");
    SC.addScreen(pconfiguracionEN, "configuracion", 1);
    SM.addScreen(psconfiguracionEN);
    
    // Pantalla de restauración de datos de fábrica
    restaurar.addElement("No restaurar", "configuracion");
    restaurar.addElement("resturar", "configuracion");
    restaurar.setBackScreen("configuracion");
    SC.addScreen(prestaurar, "restaurar", 0);
    SM.addScreen(psrestaurar);
    
    restaurarEN.addElement("do not restore", "configuracion");
    restaurarEN.addElement("restore", "configuracion");
    restaurarEN.setBackScreen("configuracion");
    SC.addScreen(prestaurarEN, "restaurar", 1);
    SM.addScreen(psrestaurarEN); 
    
    // pantalla de selección de idioma
    idioma.addElement("Espa\244ol", "configuracion");
    idioma.addElement("Ingl\202s", "configuracion");
    idioma.setBackScreen("configuracion");
    SC.addScreen(pidioma, "idioma", 0);
    SM.addScreen(psidioma);
    
    idiomaEN.addElement("Spanish", "configuracion");
    idiomaEN.addElement("English", "configuracion");
    idiomaEN.setBackScreen("configuracion");
    SC.addScreen(pidiomaEN, "idioma", 1);
    SM.addScreen(psidiomaEN);
    
    // Pantalla de selección de la forma de selección
    formaSelec.addElement("Sombreado", "configuracion");
    formaSelec.addElement("Encuadrado", "configuracion");
    formaSelec.setBackScreen("configuracion");
    SC.addScreen(pformaSelec, "formaSelec", 0);
    SM.addScreen(psformaSelec);
    
    formaSelecEN.addElement("Shading", "configuracion");
    formaSelecEN.addElement("Framing", "configuracion");
    formaSelecEN.setBackScreen("configuracion");
    SC.addScreen(pformaSelecEN, "formaSelec", 1);
    SM.addScreen(psformaSelecEN);  
    
    // Pantalla de selección de la velocidad de adquisición
    velAdquisionSel.addElement("1000 Hz", "configuracion");
    velAdquisionSel.addElement("320 Hz", "configuracion");
    velAdquisionSel.setBackScreen("configuracion");
    SC.addScreen(pvelAdquisionSel, "velAdquisionSel", ESPANOL);
    SC.addScreen(pvelAdquisionSel, "velAdquisionSel", INGLES);   // Como sólo se muestran valores y sus unidades no es necesaria esta pantalla en otros idiomas
    SM.addScreen(psvelAdquisionSel);
    
    // Pantalla de cambio de fecha y hora
    fechaHoraConf.setSelect(0);
    fechaHoraConf.setBackScreen("configuracion");
    SC.addScreen(pfechaHoraConf, "confFecha", ESPANOL);
    SM.addScreen(psfechaHoraConf);
    
    fechaHoraConfEN.setSelect(0);
    fechaHoraConfEN.setBackScreen("configuracion");
    SC.addScreen(pfechaHoraConfEN, "confFecha", INGLES);
    SM.addScreen(psfechaHoraConfEN);
    
    // Pantalla de nuevo viaje
    SC.addScreen(pnuevoViaje, "viaje", 0);
    SC.addScreen(pnuevoViajeEN, "viaje", 1);
    
    // Mensaje de USB lleno o desconectado
    noUSB.addElement("USB desconectado");
    noUSB.addElement("o lleno");
    noUSB.setBackScreen("menu");
    SC.addScreen(pnoUSB, "USBdesconectado", 0);
    
    noUSBEN.addElement("USB disconected");
    noUSBEN.addElement("or full");
    noUSBEN.setBackScreen("menu");
    SC.addScreen(pnoUSBEN, "USBdesconectado", 1);
    
    // Archivo guardado correctamente (Mensaje)
    guardadoCorrect.addElement("Archivo guardado");
    guardadoCorrect.addElement("correctamente");
    guardadoCorrect.setBackScreen("menu");
    SC.addScreen(pguardadoCorrect, "fileSaved", ESPANOL);
    
    guardadoCorrectEN.addElement("File saved");
    guardadoCorrectEN.addElement("correctly");
    guardadoCorrectEN.setBackScreen("menu");
    SC.addScreen(pguardadoCorrectEN, "fileSaved", INGLES);
    
    // Pantalla de guardado de viaje
    guardaViaje.addElement("Volver al men\243", "menu");
    //guardaViaje.addElement("Postprocesado", "menu");
    guardaViaje.addElement("Cambiar nombre", "teclado");
    guardaViaje.addElement("Borrar", "archivoBorrado");
    guardaViaje.setSelect(0);
    SC.addScreen(pguardaViaje, "guardaViaje", ESPANOL);
    SM.addScreen(psguardaViaje);
    
    guardaViajeEN.addElement("Back to menu", "menu");
    //guardaViajeEN.addElement("Postprocessing", "menu");
    guardaViajeEN.addElement("Rename", "teclado");
    guardaViajeEN.addElement("Delete", "archivoBorrado");
    guardaViajeEN.setSelect(0);
    SC.addScreen(pguardaViajeEN, "guardaViaje", INGLES);
    SM.addScreen(psguardaViajeEN);
    
    // Pantalla de las opciones de un viaje cuando accedes a él mediante la lista de viajes
    opcionesViaje.addElement("Cambiar nombre", "teclado");
    opcionesViaje.addElement("Borrar", "listadoViajes");
    opcionesViaje.setSelect(0);
    opcionesViaje.setBackScreen("listadoViajes");
    SC.addScreen(popcionesViaje, "rOptions", ESPANOL);
    SM.addScreen(psopcionesViaje);
    
    opcionesViajeEN.addElement("Rename", "teclado");
    opcionesViajeEN.addElement("Delete", "listadoViajes");
    opcionesViajeEN.setSelect(0);
    opcionesViajeEN.setBackScreen("listadoViajes");
    SC.addScreen(popcionesViajeEN, "rOptions", INGLES);
    SM.addScreen(psopcionesViajeEN);
    
    // Mensaje de archivo guardado
    SC.addScreen(parchivoGuardado, "archivoGuardado", ESPANOL);
    SC.addScreen(parchivoGuardadoEN, "archivoGuardado", INGLES);
    
    // Mensaje de archivo borrado
    archivoBorrado.addElement("Viaje borrado");
    archivoBorrado.addElement("correctamente");
    archivoBorrado.setBackScreen("menu");
    SC.addScreen(parchivoBorrado, "archivoBorrado", ESPANOL);
    
    archivoBorradoEN.addElement("Deleted file");
    archivoBorradoEN.addElement("corretly");
    archivoBorradoEN.setBackScreen("menu");
    SC.addScreen(parchivoBorradoEN, "archivoBorrado", INGLES);
    
    // Mensade de existencia de un viaje con el mismo nombre
    nombreExistente.addElement("Ya existe un");
    nombreExistente.addElement("viaje con el");
    nombreExistente.addElement("nombre introducido.");
    nombreExistente.setBackScreen("guardaViaje");
    SC.addScreen(pnombreExistente, "alredyExist", ESPANOL);
    
    nombreExistenteEN.addElement("Alredy exist a");
    nombreExistenteEN.addElement("ride with the");
    nombreExistenteEN.addElement("entered name");
    nombreExistenteEN.setBackScreen("guardaViaje");
    SC.addScreen(pnombreExistenteEN, "alredyExist", INGLES);
    
    /****************************************/
    
    /********************************************
        CARGA DE LA CONFIGURACIÓN
    ********************************************/
    char aux[16];
    // Se selecciona el idioma
    config.getIdioma(aux);
    if(strcmp(aux, "spanish") == 0){        
        SC.selectGroup(0);
    }else if(strcmp(aux, "english") == 0){
        SC.selectGroup(1);
    }
    
    // Se selecciona el modo de selección
    config.getFormaSeleccion(aux);
    if(strcmp(aux, "shading") == 0){        
        SM.setInverterSelection();
    }else if(strcmp(aux, "framing") == 0){
        SM.setRectSelection();
    }
    
    /****************************************/
        
    SC.initialize();
    while(1){
        SC.update();
    }       
}