/**
 * @author Juan Manuel Amador Olivares (virtualmech)
 */
#include "GuardarViaje.h"

extern FechaHora FH;
extern ScreenManager SC;
extern SistemaArchivos SA;
extern MSCFileSystem msc;
extern Teclado keyboard;

extern GuardarOtroNombre guardadoCorrect;
extern GuardarOtroNombre guardadoCorrectEN;

extern DigitalOut myled;

void GuardarViaje::button5pressed(DogMLCD* lcd){
    bool llamarRaiz = true;     // Se usa para llamar o no a la función padre (para controlar los cambios de pantalla)
    // Se cambia el idioma actual y se guarda tambien en el fichero de configuracion
    switch(getSelect()){
        char fileName[64];
        char auxTime[64];  
        // Volver al menú
        case 0:
            // Se guarda el nombre del archivo en la lista de nombres de los viajes              
            strcpy(auxTime, FH.getFechaHora());
            strcpy(fileName, "RAW");
            strcat(fileName, auxTime);
            SA.addElement(fileName);            
            break;
            
        // Cambiar nombre
        case 1:
            guardadoCorrect.setNextScreen("menu");
            guardadoCorrectEN.setNextScreen("menu");
            guardadoCorrect.setBackScreen("menu");
            guardadoCorrectEN.setBackScreen("menu");
            guardadoCorrect.disableNombreAntiguo();
            guardadoCorrectEN.disableNombreAntiguo();
            keyboard.setBackScreen("guardaViaje");
            keyboard.setNextScreen("fileSaved");
            break;
        // Borrar el archivo
        case 2:
            llamarRaiz = false;
            // Se borrar el archivo del último viaje        
            strcpy(auxTime, FH.getFechaHora());
            strcpy(fileName, "/usb/RAW");
            strcat(fileName, auxTime);
            strcat(fileName, ".txt");     
            
            if(remove(fileName) != 0){  // Si no se pudo borrar se avisa por pantalla de USB 
                SC.changeScreen("USBdesconectado");
            }else{
                SC.changeScreen("archivoBorrado");
            }
            break;
    }
    if(llamarRaiz){
        Menu::button5pressed(lcd);
    }
}