#include "QEI.h"
#include "mbed.h"
Serial pc(USBTX, USBRX);
double   prv_time       = 0.0;
double   now_time       = 0.0;
double   samp_time      = 0.0;
double   PI             = 3.1416;
double   fc             = 2.0*PI*5.0;
double   tau            = 1/(fc);
double   now_x          = 0.0;
double   now_y          = 0.0;
double   prv_y          = 0.0;

int main()
{
    Timer myTime;
    myTime.reset();
    myTime.start();
    pc.baud(57600);
    while(1) {
        now_time  = myTime.read_ms()/1000.0;
        samp_time = now_time - prv_time;
        now_x     = sin(2.0*PI*0.5*now_time) + 0.25*sin(2.0*PI*50.0*now_time);
        now_y     = ( samp_time * now_x + (tau * prv_y) ) / ( samp_time + tau);
    
        pc.printf("  %F      %F\r", now_x, now_y);
        printf("\n\r");
        prv_time = now_time;
        prv_y    = now_y; 
        
    }
}
