#include "mbed.h"
#include "Websocket.h"

//------------------------------------------------------------------------------------
// You need to configure these cellular modem / SIM parameters.
// These parameters are ignored for LISA-C200 variants and can be left NULL.
//------------------------------------------------------------------------------------
#include "MDM.h"
//! Set your secret SIM pin here (e.g. "1234"). Check your SIM manual.
#define SIMPIN      NULL
/*! The APN of your network operator SIM, sometimes it is "internet" check your 
    contract with the network operator. You can also try to look-up your settings in 
    google: https://www.google.de/search?q=APN+list */
#define APN         NULL
//! Set the user name for your APN, or NULL if not needed
#define USERNAME    NULL
//! Set the password for your APN, or NULL if not needed
#define PASSWORD    NULL 
//------------------------------------------------------------------------------------

Ticker flash;
DigitalOut led(LED1);
void flashLED(void){led = !led;}
    
int main() 
{
    flash.attach(&flashLED, 1.0f);
    MDMSerial mdm;
    //mdm.setDebug(4); // enable this for debugging issues 
    if (!mdm.connect(SIMPIN, APN,USERNAME,PASSWORD))
        return -1;
    
    // view @ http://sockets.mbed.org/demo/viewer
    printf("Websocket View at http://sockets.mbed.org/demo/viewer\n");
    Websocket ws("ws://sockets.mbed.org:443/ws/demo/rw");
    
    printf("Websocket\n");
    ws.connect();
    char str[100];
    printf("Websocket connected\n");
    
    for(int i=0; i<0x7fffffff; ++i) {
        // string with a message
        sprintf(str, "%d WebSocket Hello World over Cellular", i);
        ws.send(str);
    
        // clear the buffer and wait a sec...
        memset(str, 0, 100);
        wait(0.5f);
    
        // websocket server should echo whatever we sent it
        if (ws.read(str)) {
            printf("rcv'd: %s\n", str);
        }
    }
    ws.close();

    mdm.disconnect();
    mdm.powerOff();
    
    while(true);
}