// GPS resource implementation

#include "mbed.h"
#include "rtos.h"
#include "nsdl_support.h"
#include "gps_res.h"

#define GPS_RES_ID    "gps/loc"

static Mutex mutex;
static char res_gps_val[32] = "";
    
void gps_resource_set(double lat, double lon)
{
    mutex.lock();
    sprintf(res_gps_val,"%8.6f,%8.6f", lat, lon);
    mutex.unlock();
}
    
/* Only GET method allowed */
static uint8_t gps_resource_cb(sn_coap_hdr_s *received_coap_ptr, sn_nsdl_addr_s *address, sn_proto_info_s * proto)
{
    sn_coap_hdr_s *coap_res_ptr = 0;
    char gps_val[sizeof(res_gps_val)];

    printf("gps callback\r\n");
    
    coap_res_ptr = sn_coap_build_response(received_coap_ptr, COAP_MSG_CODE_RESPONSE_CONTENT);
    mutex.lock();
    strcpy(gps_val, res_gps_val);
    mutex.unlock();
    coap_res_ptr->payload_ptr = (uint8_t*)gps_val;
    coap_res_ptr->payload_len = strlen(gps_val);
    
    sn_nsdl_send_coap_message(address, coap_res_ptr);
    sn_coap_parser_release_allocated_coap_msg_mem(coap_res_ptr);
    
    return 0;
}

int create_gps_resource(sn_nsdl_resource_info_s *resource_ptr)
{
    nsdl_create_dynamic_resource(resource_ptr, sizeof(GPS_RES_ID)-1, (uint8_t*)GPS_RES_ID, 0, 0, 0, &gps_resource_cb, SN_GRS_GET_ALLOWED);
    return 0;
}

