#include "mbed.h"
#include "rtos.h"
#include "MDM.h"
#include "GPS.h"
#include "DeviceInfo.h"
#include "MbedAgent.h"
#include "apndb.h"
#include "GPSTracker.h"

/**
 * SIM PIN. Null for no pin.
 */
#define SIM_PIN NULL

/**
 * SIM GPRS login data. Leave commented out for automatic setting.
 */
#define SIM_APN NULL
#define SIM_USER NULL
#define SIM_PASS NULL

int main()
{
    MDMParser::DevStatus devStatus;
    int res;
    uint8_t status = 0;
    apndb_t *apn;

    MDMSerial mdm;
    GPSI2C gps;

    if (!mdm.init(SIM_PIN, &devStatus))
        status = 1;
    else if (!gps.init())
        status = 2;
    
    DeviceIO io(gps);

    switch (status) {
    case 1:
        io.lcdPrint("MODEM INIT FAILURE", "REMOVE SIM PIN");
        break;
    case 2:
        io.lcdPrint("GPS INIT FAILURE");
        break;
    }
    
    if (status != 0)
        goto error;
    
    io.lcdPrint("DEVICE INIT");
    
    /*if (io.resetButtonPressed()) {
        puts("Resetting program.");
        res = mdm.delFile("001_CREDENTIALS");
        if (res < 0) {
            puts("Credential reset failed.");
            io.lcdPrint("CREDENTIAL RESET", "FAILURE", "PLEASE RESTART DEVICE");
        } else {
            puts("Credential reset successful.");
            io.lcdPrint("CREDENTIAL RESET", "SUCCESS", "PLEASE RESTART DEVICE");
        }
        return 0;
    }*/

    io.lcdPrint("IMEI", devStatus.imei);

#ifndef SIM_APN
    apn = apndb_get(devStatus.imsi);
    if (apn == NULL) {
        io.lcdPrint("NO CARRIER FOUND", "CHECK IMSI", devStatus.imsi);
        goto error;
    }
#endif
    
    if (!mdm.registerNet()) {
        io.lcdPrint("NETWORK REG ERROR");
        goto error;
    }

#ifdef SIM_APN
    if (mdm.join(SIM_APN, SIM_USER, SIM_PASS) == NOIP) {
        io.lcdPrint("NETWORK JOIN FAILURE");
        goto error;
    }
#else
    io.lcdPrint("JOINING CARRIER", apn->carrier);
    if (mdm.join(apn->apn) == NOIP) {
        io.lcdPrint("NETWORK JOIN FAILURE");
        goto error;
    }
#endif
    
    {
        uint8_t tries;
        DeviceInfo deviceInfo(mdm, devStatus);
        MbedAgent agent(io, mdm, deviceInfo);
    
        io.lcdPrint("AGENT INIT");
        if (!agent.init()) {
            io.lcdPrint("AGENT INIT FAILURE");
            goto error;
        }
        
        tries = 3;
        do {
            io.lcdPrint("AGENT RUN");
            if (agent.run())
                break;
        } while (--tries > 0);

        if (tries == 0) {
            io.lcdPrint("AGENT RUN FAILURE");
            goto error;
        }
    }
    
    mdm.disconnect();
    return 0;

error:
    io.lcdPrint("DISCONNECTING");
    mdm.disconnect();
    return 1;
}
