#include "SignalQualityMeasurement.h"
#include "ComposedRecord.h"
#include "CharValue.h"
#include "IntegerValue.h"
#include "FloatValue.h"

SignalQualityMeasurement::SignalQualityMeasurement(SmartRest& client, SmartRestTemplate& tpl, long& deviceId, DeviceInfo& deviceInfo) :
    _client(client),
    _tpl(tpl),
    _deviceId(deviceId),
    _deviceInfo(deviceInfo)
{
    _init = false;
}

bool SignalQualityMeasurement::init()
{
    if (_init)
        return false;
    
    // Insert measurement
    // USAGE: 104,<DEVICE/ID>,<RSSI>,<BER>
    if (!_tpl.add("10,104,POST,/measurement/measurements,application/vnd.com.nsn.cumulocity.measurement+json,application/vnd.com.nsn.cumulocity.measurement+json,%%,NOW UNSIGNED NUMBER UNSIGNED,\"{\"\"time\"\":\"\"%%\"\",\"\"source\"\":{\"\"id\"\":\"\"%%\"\"},\"\"type\"\":\"\"c8y_SignalStrength\"\",\"\"c8y_SignalStrength\"\":{\"\"rssi\"\":{\"\"value\"\":%%,\"\"unit\"\":\"\"dBm\"\"},\"\"ber\"\":{\"\"value\"\":%%,\"\"unit\"\":\"\"%\"\"}}}\"\r\n"))
        return false;

    _init = true;
    return true;
}

bool SignalQualityMeasurement::run()
{
    DeviceInfo::SignalQuality *signalQuality;
    
    if ((signalQuality = _deviceInfo.signalQuality()) == NULL)
        return false;
        
    ComposedRecord record;
    IntegerValue msgId(104);
    IntegerValue devId(_deviceId);
    IntegerValue rssi(signalQuality->rssi);
    IntegerValue ber(signalQuality->ber);
    if ((!record.add(msgId)) || (!record.add(devId)) || (!record.add(rssi)) || (!record.add(ber)))
        return false;

    if (_client.send(record) != SMARTREST_SUCCESS) {
        puts("Signal measurement failed.");
        _client.stop();
        return false;
    }
    _client.stop();
    return true;
}
