#include "MbedAgent.h"
#include "rtos.h"

MbedAgent::MbedAgent(DeviceIO& io, MDMSerial& mdm, DeviceInfo& deviceInfo) :
    _io(io),
    _mdm(mdm),
    _deviceInfo(deviceInfo),
    _client(MBED_AGENT_HOST, MBED_AGENT_PORT, MBED_AGENT_DEVICE_IDENTIFIER),
    _bootstrap(_client, _mdm, _io, _deviceInfo),
    _integration(_client, _tpl, _deviceId, _deviceInfo),
    _signalQualityMeasurement(_client, _tpl, _deviceId, _deviceInfo),
    _temperatureMeasurement(_client, _tpl, _deviceId, _io.temperatureSensor()),
    _accelerationMeasurement(_client, _tpl, _deviceId, _io.accelerometer()),
    _analogMeasurement(_client, _tpl, _deviceId, _io.analog1(), _io.analog2()),
    _locationUpdate(_client, _tpl, _deviceId, _io.gpsTracker()),
    _deviceId(0)
{
}

bool MbedAgent::init()
{
    if ((!_integration.init()) ||
        (!_signalQualityMeasurement.init()) ||
        (!_temperatureMeasurement.init()) ||
        (!_accelerationMeasurement.init()) ||
        (!_analogMeasurement.init()) ||
        (!_locationUpdate.init())) {
        puts("Initialization failed.");
        return false;
    }
    return true;
}

bool MbedAgent::run()
{
    // device bootstrapping process
    if (!_bootstrap.setUpCredentials())
        return false;

    Thread::wait(5000);

    _io.lcdPrint("INTEGRATION");
    if (!_integration.integrate()) {
        return false;
    }
    
    char status[60];
    snprintf(status, sizeof(status), "ID: %ld", _deviceId);
    _io.lcdPrint("INTEGRATED", status);

    loop();
    return true;
}

void MbedAgent::loop()
{
    Timer timer;
    
    timer.start();
    while (true) {
        timer.reset();
        
        _signalQualityMeasurement.run();
        _temperatureMeasurement.run();
        _accelerationMeasurement.run();
        _analogMeasurement.run();
        _locationUpdate.run();
        
        while (timer.read() < MBED_AGENT_INTERVAL) {
            Thread::yield();
        }
    }
}