#include "LocationUpdate.h"
#include "Aggregator.h"
#include "ComposedRecord.h"
#include "CharValue.h"
#include "IntegerValue.h"
#include "FloatValue.h"

LocationUpdate::LocationUpdate(SmartRest& client, SmartRestTemplate& tpl, long& deviceId, GPSTracker& gpsTracker) :
    _client(client),
    _tpl(tpl),
    _deviceId(deviceId),
    _gpsTracker(gpsTracker)
{
    _init = false;
}

bool LocationUpdate::init()
{
    if (_init)
        return false;
    
    // Update device position
    // USAGE: 108,<DEVICE/ID>,<ALTITUDE>,<LATITUDE>,<LONGITUDE>
    if (!_tpl.add("10,108,PUT,/inventory/managedObjects/%%,application/vnd.com.nsn.cumulocity.managedObject+json,application/vnd.com.nsn.cumulocity.managedObject+json,%%,UNSIGNED NUMBER NUMBER NUMBER,\"{\"\"c8y_Position\"\":{\"\"alt\"\":%%,\"\"lat\"\":%%,\"\"lng\"\":%%},\"\"c8y_MotionTracking\"\":{\"\"active\"\":true}}\"\r\n"))
        return false;

    // Insert measurement
    // USAGE: 109,<DEVICE/ID>,<ALTITUDE>,<LATITUDE>,<LONGITUDE>
    if (!_tpl.add("10,109,POST,/event/events,application/vnd.com.nsn.cumulocity.event+json,application/vnd.com.nsn.cumulocity.event+json,%%,NOW UNSIGNED NUMBER NUMBER NUMBER,\"{\"\"time\"\":\"\"%%\"\",\"\"source\"\":{\"\"id\"\":\"\"%%\"\"},\"\"type\"\":\"\"c8y_LocationUpdate\"\",\"\"text\"\":\"\"Mbed location update\"\",\"\"c8y_Position\"\":{\"\"alt\"\":%%,\"\"lat\"\":%%,\"\"lng\"\":%%}}\""))
        return false;

    _init = true;
    return true;
}

bool LocationUpdate::run()
{
    GPSTracker::Position position;
    
    if (!_gpsTracker.position(&position)) {
        puts("No GPS data available.");
        return true;
    }
        
    puts("Starting measurement sending.");

    Aggregator aggregator;
    ComposedRecord record1, record2;
    IntegerValue msgId1(108);
    IntegerValue msgId2(109);
    IntegerValue devId(_deviceId);
    FloatValue altitude(position.altitude, 2);
    FloatValue latitude(position.latitude, 6);
    FloatValue longitude(position.longitude, 6);
    if ((!record1.add(msgId1)) || (!record1.add(devId)) || (!record1.add(altitude)) || (!record1.add(latitude)) || (!record1.add(longitude)))
        return false;
    if ((!record2.add(msgId2)) || (!record2.add(devId)) || (!record2.add(altitude)) || (!record2.add(latitude)) || (!record2.add(longitude)))
        return false;
    if ((!aggregator.add(record1)) || (!aggregator.add(record2)))
        return false;

    puts("Sending GPS measurement.");
    if (_client.send(aggregator) != SMARTREST_SUCCESS) {
        puts("Signal measurement failed.");
        _client.stop();
        return false;
    }

    _client.stop();
    return true;
}
