#include "DeviceIO.h"
#include "PinNames.h"

#define DEF "\033[39m"
#define GRE "\033[32m"
#define CYA "\033[36m"

DeviceIO::DeviceIO(GPSI2C& gps) :
    _gpsTracker(gps),
    _resetButton(D4), // fire button on arduino app shield
    _analog1(A0),
    _analog2(A1),
    _temperatureSensor(D14/*SDA*/, D15/*SCL*/),
    _accelerometer(D14/*SDA*/, D15/*SCL*/),
    _lcd(D11, D13, D12, D7, D10)
{
}

bool DeviceIO::resetButtonPressed()
{
    return _resetButton;
}

GPSTracker& DeviceIO::gpsTracker()
{
    return _gpsTracker;
}

AnalogIn& DeviceIO::analog1()
{
    return _analog1;
}

AnalogIn& DeviceIO::analog2()
{
    return _analog2;
}
LM75B& DeviceIO::temperatureSensor()
{
    return _temperatureSensor;
}

MMA7660& DeviceIO::accelerometer()
{
    return _accelerometer;
}

void DeviceIO::lcdPrint(const char *line1, const char *line2, const char *line3)
{
    printf(GRE "io::lcdPrint" DEF "\r\n");
    _lcd.cls();
    _lcd.locate(0, 0);

    _lcd.printf("%s\n", line1);
    printf(GRE "> " CYA "%s\r\n" DEF, line1);

    if (line2 != NULL) {
        _lcd.printf("%s\n", line2);
        printf(GRE "> " CYA "%s\r\n" DEF, line2);

        if (line3 != NULL) {
            _lcd.printf("%s\n", line3);
            printf(GRE "> " CYA "%s\r\n" DEF, line3);
        }
    }
}
