#include "AnalogMeasurement.h"
#include "ComposedRecord.h"
#include "CharValue.h"
#include "IntegerValue.h"
#include "FloatValue.h"

AnalogMeasurement::AnalogMeasurement(SmartRest& client, SmartRestTemplate& tpl, long& deviceId, AnalogIn& analog1, AnalogIn& analog2) :
    _client(client),
    _tpl(tpl),
    _deviceId(deviceId),
    _analog1(analog1),
    _analog2(analog2)
{
    _init = false;
}

bool AnalogMeasurement::init()
{
    if (_init)
        return false;
    
    // Insert measurement
    // USAGE: 107,<DEVICE/ID>,<ANALOG1>,<ANALOG2>
    if (!_tpl.add("10,107,POST,/measurement/measurements,application/vnd.com.nsn.cumulocity.measurement+json,application/vnd.com.nsn.cumulocity.measurement+json,%%,NOW UNSIGNED NUMBER NUMBER,\"{\"\"time\"\":\"\"%%\"\",\"\"source\"\":{\"\"id\"\":\"\"%%\"\"},\"\"type\"\":\"\"c8y_AnalogMeasurement\"\",\"\"c8y_AnalogMeasurement\"\":{\"\"A1\"\":{\"\"value\"\":%%,\"\"unit\"\":\"\"A\"\"},\"\"A2\"\":{\"\"value\"\":%%,\"\"unit\"\":\"\"A\"\"}}}\"\r\n"))
        return false;

    _init = true;
    return true;
}

bool AnalogMeasurement::run()
{
    ComposedRecord record;
    IntegerValue msgId(107);
    IntegerValue devId(_deviceId);
    FloatValue analog1(_analog1.read(), 1);
    FloatValue analog2(_analog2.read(), 1);
    if ((!record.add(msgId)) || (!record.add(devId)) || (!record.add(analog1)) || (!record.add(analog2)))
        return false;

    if (_client.send(record) != SMARTREST_SUCCESS) {
        puts("Signal measurement failed.");
        _client.stop();
        return false;
    }
    _client.stop();
    return true;
}
