#include "AccelerationMeasurement.h"
#include "ComposedRecord.h"
#include "CharValue.h"
#include "IntegerValue.h"
#include "FloatValue.h"

AccelerationMeasurement::AccelerationMeasurement(SmartRest& client, SmartRestTemplate& tpl, long& deviceId, MMA7660& sensor) :
    _client(client),
    _tpl(tpl),
    _deviceId(deviceId),
    _sensor(sensor)
{
    _init = false;
}

bool AccelerationMeasurement::init()
{
    if (_init)
        return false;
    
    // Insert measurement
    // USAGE: 106,<DEVICE/ID>,<X>,<Y>,<Z>
    if (!_tpl.add("10,106,POST,/measurement/measurements,application/vnd.com.nsn.cumulocity.measurement+json,application/vnd.com.nsn.cumulocity.measurement+json,%%,NOW UNSIGNED NUMBER NUMBER NUMBER,\"{\"\"time\"\":\"\"%%\"\",\"\"source\"\":{\"\"id\"\":\"\"%%\"\"},\"\"type\"\":\"\"c8y_MotionMeasurement\"\",\"\"c8y_MotionMeasurement\"\":{\"\"x\"\":{\"\"value\"\":%%,\"\"unit\"\":\"\"m^2/s\"\"},\"\"y\"\":{\"\"value\"\":%%,\"\"unit\"\":\"\"m^2/s\"\"},\"\"z\"\":{\"\"value\"\":%%,\"\"unit\"\":\"\"m^2/s\"\"}}}\"\r\n"))
        return false;

    _test = _sensor.testConnection();
    _init = true;
    return true;
}

bool AccelerationMeasurement::run()
{
    float data[3] = { 0.0, 0.0, 0.0 };
    
    if (!_test)
        return false;
        
    _sensor.readData(data);

    ComposedRecord record;
    IntegerValue msgId(106);
    IntegerValue devId(_deviceId);
    FloatValue xValue(data[0], 2);
    FloatValue yValue(data[1], 2);
    FloatValue zValue(data[2], 2);
    if ((!record.add(msgId)) || (!record.add(devId)) || (!record.add(xValue)) || (!record.add(yValue)) || (!record.add(zValue)))
        return false;

    if (_client.send(record) != SMARTREST_SUCCESS) {
        puts("Signal measurement failed.");
        _client.stop();
        return false;
    }
    _client.stop();
    return true;
}
