#include "TemperatureMeasurement.h"
#include "ComposedRecord.h"
#include "CharValue.h"
#include "IntegerValue.h"
#include "FloatValue.h"

TemperatureMeasurement::TemperatureMeasurement(SmartRest& client, SmartRestTemplate& tpl, long& deviceId, LM75B& sensor) :
    _client(client),
    _tpl(tpl),
    _deviceId(deviceId),
    _sensor(sensor)
{
    _init = false;
}

bool TemperatureMeasurement::init()
{
    if (_init)
        return false;
    
    // Insert measurement
    // USAGE: 105,<DEVICE/ID>,<TEMPERATURE>
    if (!_tpl.add("10,105,POST,/measurement/measurements,application/vnd.com.nsn.cumulocity.measurement+json,application/vnd.com.nsn.cumulocity.measurement+json,%%,NOW UNSIGNED NUMBER,\"{\"\"time\"\":\"\"%%\"\",\"\"source\"\":{\"\"id\"\":\"\"%%\"\"},\"\"type\"\":\"\"c8y_TemperatureMeasurement\"\",\"\"c8y_TemperatureMeasurement\"\":{\"\"T\"\":{\"\"value\"\":%%,\"\"unit\"\":\"\"C\"\"}}}\"\r\n"))
        return false;

    _open = _sensor.open();
    _init = true;
    return true;
}

bool TemperatureMeasurement::run()
{
    if (!_open)
        return false;

    ComposedRecord record;
    IntegerValue msgId(105);
    IntegerValue devId(_deviceId);
    FloatValue temperature(_sensor.temp(), 1);
    if ((!record.add(msgId)) || (!record.add(devId)) || (!record.add(temperature)))
        return false;

    if (_client.send(record) != SMARTREST_SUCCESS) {
        puts("Signal measurement failed.");
        _client.stop();
        return false;
    }
    _client.stop();
    return true;
}
