#include "apndb.h"
#include "stdlib.h"
#include "stdio.h"
#include "string.h"

// Contains all tuples
apndb_t apndb[] = {
    { .mcc = "262", .mnc = "01", .carrier = "Telekom Deutschland", .apn = "internet.m2mportal.de" },
    { .mcc = "262", .mnc = "02", .carrier = "Telekom", .apn = "m2m.business" },
    { .mcc = "232", .mnc = "03", .carrier = "Telekom", .apn = "m2m.business" },
    { .mcc = "262", .mnc = "06", .carrier = "Telekom", .apn = "m2m.business" },
    { .mcc = "204", .mnc = "04", .carrier = "Vodafone NL", .apn = "public4.m2minternet.com" },
    { .mcc = NULL, .mnc = NULL, .carrier = NULL, .apn = NULL } // ending terminator
};

apndb_t * apndb_get(const char * imsi)
{
    char chr1[8], chr2[8];
    size_t len;
    size_t i;
    
    i = 0;
    while (apndb[i].mcc != NULL) {
        strcpy(chr1, apndb[i].mcc);
        strcat(chr1, apndb[i].mnc);
        len = strlen(chr1);
        strncpy(chr2, imsi, len);
        chr2[len] = '\0';
        
        if (strcmp(chr1, chr2) == 0)
            return &apndb[i];
        i++;
    }
    
    return NULL;
}
