#ifndef MBEDAGENT_H
#define MBEDAGENT_H

#include <stddef.h>
#include "MDM.h"
#include "DeviceIO.h"
#include "MbedSmartRest.h"
#include "SmartRestTemplate.h"
#include "DeviceInfo.h"
#include "DeviceBootstrap.h"
#include "DeviceIntegration.h"
#include "SignalQualityMeasurement.h"
#include "TemperatureMeasurement.h"
#include "AccelerationMeasurement.h"
#include "AnalogMeasurement.h"
#include "LocationUpdate.h"

#define MBED_AGENT_HOST "developer.cumulocity.com"
#define MBED_AGENT_PORT 80
#define MBED_AGENT_DEVICE_IDENTIFIER "com_cumulocity_MbedAgent_1.0.5"
#define MBED_AGENT_INTERVAL 60.0

class MbedAgent
{
public:
    MbedAgent(DeviceIO&, MDMSerial&, DeviceInfo&);
    
    bool init();
    bool run();

protected:
    void loop();
    
private:
    DeviceIO& _io;
    MDMSerial& _mdm;
    DeviceInfo& _deviceInfo;
    MbedSmartRest _client;
    SmartRestTemplate _tpl;
    DeviceBootstrap _bootstrap;
    DeviceIntegration _integration;
    SignalQualityMeasurement _signalQualityMeasurement;
    TemperatureMeasurement _temperatureMeasurement;
    AccelerationMeasurement _accelerationMeasurement;
    AnalogMeasurement _analogMeasurement;
    LocationUpdate _locationUpdate;
    long _deviceId;
};

#endif