#ifndef DEVICEINTEGRATION_H
#define DEVICEINTEGRATION_H

#include "SmartRest.h"
#include "SmartRestTemplate.h"
#include "DeviceInfo.h"

class DeviceIntegration
{
public:
    DeviceIntegration(SmartRest&, SmartRestTemplate&, long&, DeviceInfo&);
    
    bool init();
    bool integrate();

protected:
    bool deviceExisting();
    bool createDevice();
    bool addGlobalIdentifier();
    bool updateDevice();

private:
    bool _init;
    long& _deviceId;
    SmartRestTemplate& _tpl;
    SmartRest& _client;
    DeviceInfo& _deviceInfo;
};

#endif