#ifndef DEVICEIO_H
#define DEVICEIO_H

#include "mbed.h"
#include "GPSTracker.h"
#include "GPS.h"
#include "LM75B.h"
#include "MMA7660.h"
#include "C12832.h"

class DeviceIO
{
public:
    DeviceIO(GPSI2C&);

    bool resetButtonPressed();
    GPSTracker& gpsTracker();
    AnalogIn& analog1();
    AnalogIn& analog2();
    LM75B& temperatureSensor();
    MMA7660& accelerometer();
    void lcdPrint(const char*, const char* = NULL, const char* = NULL);

private:
    GPSTracker _gpsTracker;
    DigitalIn _resetButton;
    AnalogIn _analog1;
    AnalogIn _analog2;
    LM75B _temperatureSensor;
    MMA7660 _accelerometer;
    C12832 _lcd;
};

#endif