#ifndef DEVICEBOOTSTRAP_H
#define DEVICEBOOTSTRAP_H

#include <stddef.h>
#include "MDM.h"
#include "DeviceIO.h"
#include "SmartRest.h"
#include "DeviceInfo.h"

/** The username used for device bootstrapping. */
#define DEVICE_BOOTSTRAP_USERNAME "management/devicebootstrap"

/** The password used for device bootstrapping. */
#define DEVICE_BOOTSTRAP_PASSWORD "Fhdt1bb1f"

#define DEVICE_BOOTSTRAP_CREDENTIALS_LENGTH 256

#define CREDENTIALS_FILE "001_CREDENTIALS"

class DeviceBootstrap
{
public:
    DeviceBootstrap(SmartRest&, MDMSerial&, DeviceIO&, DeviceInfo&);
    
    bool setUpCredentials();
    const char * username();
    const char * password();

protected:
    bool obtainFromStorage();
    bool obtainFromPlatform();

private:
    bool writeToStorage();
    void setCredentials(const char *, const char*, const char*);

private:
    SmartRest& _client;
    MDMSerial& _mdm;
    DeviceInfo& _deviceInfo;
    DeviceIO& _io;
    char _username[DEVICE_BOOTSTRAP_CREDENTIALS_LENGTH],                    
         _password[DEVICE_BOOTSTRAP_CREDENTIALS_LENGTH];
};

#endif