#include "DeviceBootstrap.h"
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "rtos.h"
#include "ComposedRecord.h"
#include "CharValue.h"
#include "IntegerValue.h"
#include "ParsedRecord.h"

DeviceBootstrap::DeviceBootstrap(SmartRest& client, MDMSerial& mdm, DeviceIO& io, DeviceInfo& deviceInfo) :
    _client(client),
    _mdm(mdm),
    _io(io),
    _deviceInfo(deviceInfo)
{
    *_username = *_password = '\0';
}

bool DeviceBootstrap::setUpCredentials()
{
    if (((*_username == '\0') || (*_password == '\0')) &&
        (!obtainFromStorage())) {
        if (!obtainFromPlatform())
            return false;
        if (!writeToStorage())
            puts("Warning: Could not write credentials to file!");
    }

    if (_client.setAuthorization(_username, _password) != SMARTREST_SUCCESS)
        return false;
    return true;
}

const char * DeviceBootstrap::username()
{
    return _username;
}

const char * DeviceBootstrap::password()
{
    return _password;
}

bool DeviceBootstrap::obtainFromStorage()
{
    char buf[DEVICE_BOOTSTRAP_CREDENTIALS_LENGTH*2+2], *ptr;
    
    int res = _mdm.readFile(CREDENTIALS_FILE, buf, sizeof(buf));
    if (res < 0)
        return false;
        
    buf[res] = '\0';
    if ((ptr = strchr(buf, '\n')) == NULL)
        return false;
    *ptr = '\0';
    
    ptr = buf;
    strcpy(_username, ptr);
    ptr += strlen(ptr)+1;
    strcpy(_password, ptr);
    return true;
}

bool DeviceBootstrap::obtainFromPlatform()
{
    uint8_t ret;
    uint8_t tries;
    
    ComposedRecord record;
    ParsedRecord recvdRecord;

    IntegerValue msgId(61);
    CharValue identifier(_deviceInfo.imei());
    if ((!record.add(msgId)) || (!record.add(identifier)))
        return false;

    // set authorization for bootstrap
    if (_client.setAuthorization(DEVICE_BOOTSTRAP_USERNAME, DEVICE_BOOTSTRAP_PASSWORD) != SMARTREST_SUCCESS)
        return false;

    _io.lcdPrint("BOOTSTRAP", _deviceInfo.imei());
    
    tries = 255;
    do {
        if (_client.send(record, "") != SMARTREST_SUCCESS) {
            _client.stop();
            Thread::wait(2000);
            continue;
        }
        
        if (_client.receive(recvdRecord) != SMARTREST_SUCCESS) {
            _client.stop();
            Thread::wait(2000);
            continue;
        }
        _client.stop();
        
        for (size_t q = 0; q < recvdRecord.values(); q++)
            puts(recvdRecord.rawValue(q));
            
        if ((recvdRecord.values() < 1) ||
            (recvdRecord.value(0).integerValue() == 50)) {
            Thread::wait(2000);
            continue;
        }
        
        if ((recvdRecord.value(0).integerValue() != 70) ||
            (recvdRecord.values() != 6)) {
            return false;
        }
        
        setCredentials(recvdRecord.value(3).characterValue(),
                       recvdRecord.value(4).characterValue(),
                       recvdRecord.value(5).characterValue());
        
        _io.lcdPrint("BOOTSTRAP SUCCESSFUL", _username, _password);

        return true;
    } while (--tries > 0);

    _io.lcdPrint("BOOTSTRAP FAILURE");
    return false;
}

bool DeviceBootstrap::writeToStorage()
{
    char buf[DEVICE_BOOTSTRAP_CREDENTIALS_LENGTH*2+2], *ptr;
    size_t len;

    ptr = buf;
    len = strlen(_username);
    strcpy(ptr, _username);
    ptr += len;
    
    *ptr++ = '\n';
    len++;
    
    len += strlen(_password);
    strcpy(ptr, _password);
    
    _mdm.delFile(CREDENTIALS_FILE);
    _mdm.writeFile(CREDENTIALS_FILE, buf, len);
    return true;
}

void DeviceBootstrap::setCredentials(const char *tenant, const char *username, const char *password)
{
    *_username = '\0';
    if (tenant != NULL) {
        strncpy(_username, tenant, DEVICE_BOOTSTRAP_CREDENTIALS_LENGTH);
        _username[DEVICE_BOOTSTRAP_CREDENTIALS_LENGTH-1] = '\0';
        if (strlen(_username)+1 < DEVICE_BOOTSTRAP_CREDENTIALS_LENGTH)
            strcat(_username, "/");
    }
    strncat(_username, username, DEVICE_BOOTSTRAP_CREDENTIALS_LENGTH-strlen(_username));
    _username[DEVICE_BOOTSTRAP_CREDENTIALS_LENGTH-1] = '\0';

    strncpy(_password, password, DEVICE_BOOTSTRAP_CREDENTIALS_LENGTH);
    _password[DEVICE_BOOTSTRAP_CREDENTIALS_LENGTH-1] = '\0';
}
