#pragma once 

#include "mbed.h"

#define ISCMEERROR(X)  (X == MDMParser::RESP_ERROR_CME)
#define RESPOK(X)     (X == MDMParser::RESP_OK)
#define BOOLTOSTR(b)  (b?"true":"false")

/****************************/
//! general response
typedef enum {
    RES_OK = 0,                 //! Ok
    RES_ERROR = -1,             //! Error
    RES_ERROR_STUCK = -2        //! Blocking Error
} CNResp;

/****************************/
#define CN_DEBUG

#ifdef CN_DEBUG
#if 1 // colored terminal output using ANSI escape sequences
  #define COL(c) "\033[" c
 #else
  #define COL(c)
 #endif
 #define DEF COL("39m")
 #define BLA COL("30m")
 #define RED COL("31m")
 #define GRE COL("32m")
 #define YEL COL("33m")
 #define BLU COL("34m")
 #define MAG COL("35m")
 #define CYA COL("36m")
 #define WHY COL("37m")

void debugPrint(int level, const char* color, const char* format, ...);

 #define ERROR(...)     debugPrint(0, RED, __VA_ARGS__)
 #define INFO(...)      debugPrint(1, GRE, __VA_ARGS__)
 #define TRACE(...)     debugPrint(2, DEF, __VA_ARGS__)
 #define TEST(...)      debugPrint(3, CYA, __VA_ARGS__)

#else
 #define ERROR(...) (void)0 // no tracing
 #define TEST(...)  (void)0 // no tracing
 #define INFO(...)  (void)0 // no tracing
 #define TRACE(...) (void)0 // no tracing

#endif

int getUtilDebugLevel();
bool setUtilDebugLevel(int level);

/**************************************/

class CNTimer : Timer {
public:
    CNTimer(): Timer(), _counter(0) {}

    void start();
    bool isExpired();
    bool isOn() { return (_counter > 0);}
    void stop() { Timer::stop(); Timer::reset(); _counter = 0;}
    void reset() {Timer::reset();}
    int read() {return Timer::read_ms();}
    int getRetryContunter() {return _counter;}
    void setExpireTimeout(int timeout)  {_timeout = timeout;}
    int getTimeout() {return _timeout;}

private:
    int _timeout;
    int _counter;
};