#include "CNReg.h"
#include "CNLib.h"

#define ISREG(r)        ((r == MDMParser::REG_HOME) || (r == MDMParser::REG_ROAMING))
#define ISROMAING(r)    (r == MDMParser::REG_ROAMING)
#define ISUNKKOWN(r)    (r == MDMParser::REG_UNKNOWN)

static MDMParser::Reg stateCS;      //!< CS registration status
static MDMParser::Reg statePS;      //!< PS registration status
static CNTimer tmStatusPull;       //!< timer for polling registration status
static bool isRomaingEnabled;       //!< roaming is allowed

void cnRegInit(){
    TRACE("%s enter \r\n", __FUNCTION__);
    stateCS = MDMParser::REG_UNKNOWN;
    statePS = MDMParser::REG_UNKNOWN;
    tmStatusPull.setExpireTimeout(TIMEOUT_POLLING_NETWORK_STATUS);
    tmStatusPull.start();
}

void cnRegSetRoaming(bool enabled){
    isRomaingEnabled = enabled;
}

void cnRegReset(){
    TRACE("%s enter \r\n", __FUNCTION__);
    stateCS = MDMParser::REG_UNKNOWN;
    statePS = MDMParser::REG_UNKNOWN;
}

CNResp cnRegLoop(CNLib* cnLib, RegStatus* regStatus){
    MDMParser::Reg newStateCS = cnLib->getNet()->csd;
    MDMParser::Reg newStatePS = cnLib->getNet()->psd;
    bool isRoamingRegister, isCSRegistered, hasCsRegister, hasCsDeRegister, isPSRegistered, hasPsRegister, hasPsDeRegister;
    *regStatus = REG_NO_CHANGES;
    int res;
    
    TRACE("%s enter \r\n", __FUNCTION__); 
    //read and set COPS if necessary
    if (cnLib->getNet()->regStatus == MDMParser::COPS_UNKOWN){
        res = cnLib->getNetworkInfo();
        if (!RESPOK(res)) return RES_ERROR;
    }
    if (cnLib->getNet()->regStatus != MDMParser::COPS_AUTOMATIC_REG)
        cnLib->setNetAutoReg();    
    // poll registration info when timer expires
    if (tmStatusPull.isExpired()){
        INFO("%s Polling Net Info timer Expired, checking net status\r\n", __FUNCTION__);
        cnLib->checkNetStatus();
         newStateCS = cnLib->getNet()->csd;
         newStatePS = cnLib->getNet()->psd;
        if (!tmStatusPull.isOn())
            tmStatusPull.start();
    }
    //recover an old value in case of read errors
    if (ISUNKKOWN(newStateCS)) newStateCS = stateCS;
    if (ISUNKKOWN(newStatePS)) newStatePS = statePS;        
    //process registration changes
    isRoamingRegister = ISROMAING(stateCS) || ISROMAING(statePS);
    isCSRegistered = ISREG(stateCS);
    hasCsRegister = (!isCSRegistered && ISREG(newStateCS));
    hasCsDeRegister = ( isCSRegistered && !ISREG(newStateCS));
    isPSRegistered = ISREG(statePS);
    hasPsRegister = ( !isPSRegistered && ISREG(newStatePS));
    hasPsDeRegister = ( isPSRegistered && !ISREG(newStatePS));
    //verify roaming
    if (!isRoamingRegister || (isRoamingRegister && isRomaingEnabled)){
        //verify registration
        if ((isCSRegistered && hasPsRegister) || (isPSRegistered &&  hasCsRegister) || \
                (hasPsRegister && hasCsRegister) ){
            TRACE("%s CS and PS have just registered\r\n", __FUNCTION__);
            *regStatus = REG_REGISTERED;
        }
        else if (hasPsDeRegister || hasCsDeRegister){
            TRACE("%s CS or PS are not registered\r\n", __FUNCTION__);
            *regStatus = REG_NOT_REGISTERED;
        }
    }else{
        INFO("%s Roaming not allowed\r\n", __FUNCTION__);
        *regStatus = REG_NOT_REGISTERED;
    }
    //Perform action in base of registration status
    if (hasCsRegister){
        //cnLib->getNetMccMnc();
    } else if (hasCsDeRegister){
        //cnLib->getNet()->netMccMnc = 0;
        memset(cnLib->getNet()->opr, 0, strlen(cnLib->getNet()->opr));
    }
    //Dump info
    if (getUtilDebugLevel() > 1 && (newStatePS != statePS || newStateCS != stateCS )){
        const char* txtStatus[] = { "unchanged", "registered", "NOT registered"};
        INFO("cn registration Dump\r\n");
        if (*regStatus < sizeof(txtStatus)/sizeof(*txtStatus))
                INFO("  Status is now %s\r\n", txtStatus[*regStatus]);
        INFO("  has CS Registered = %s, has CS DeRegistered = %s\r\n", BOOLTOSTR(hasCsRegister), BOOLTOSTR(hasCsDeRegister));
        INFO("  is Roaming active = %s, polling Timer %d\r\n", \
                BOOLTOSTR(isRoamingRegister), tmStatusPull.read());
        //cnLib->dumpNetStatus(cnLib->getNet());
    }
    //update status
    stateCS = newStateCS;
    statePS = newStatePS;
    
    return RES_OK;    
}