#include "CNUtil.h"
#include <stdarg.h>

static int _debugLevel = 1;

int getUtilDebugLevel(){
    return _debugLevel;
}
bool setUtilDebugLevel(int level){
#ifdef CN_DEBUG
    if ((_debugLevel >= -1) && (level >= -1) &&
        (_debugLevel <=  3) && (level <=  3)) {
        _debugLevel = level;
        return true;
    }
#endif
    return false;
}

void debugPrint(int level, const char* color, const char* format, ...)
{
#ifdef CN_DEBUG
    if (_debugLevel >= level)
    {
        va_list args;
        va_start (args, format);
        if (color) ::printf(color);
        ::vprintf(format, args);
        if (color) ::printf(DEF);
        va_end (args);
    }
#endif
}

void CNTimer::start() {
    if (_counter++ == 0) Timer::start();
        else Timer::reset();
}
bool CNTimer::isExpired(){
    if (Timer::read_ms() > _timeout) {
        Timer::reset();
        return true;
    }
    else return false;
}