#pragma once 

#include "MDM.h"

class CNLib : public MDMSerial {

public:
    CNLib() : MDMSerial() {};

    /** Power on the modem     
     */
    int  powerOnModem();

    /** Inti the modem
     */
    int initModem();

    /** init the sim card
        \simpin pin of the sim, NULL if no sim pin is used
     */
    int simInit(const char* simpin);
    
    /** Get Sim Status
     */
    int getSimInfo();

    /** Get Network status info
     */
    int getNetworkInfo();
    
    /** Set module to auto registration
     */
    int setNetAutoReg();

    /** get Internal data context status
     */
    int getInternalStatusContext();
    
    /** Disable internal data Context      
     */
    int disableInternalContext();

    /**
      \return NetStatus
     */
    NetStatus* getNet(){return &_net;}
    
    /**
      \return DevStatus
     */
    DevStatus* getDev(){return &_dev;}


protected:
    static int _mcbCPIN(int type,  const char* buf, int len, Sim* sim);
};