#pragma once 

#include "CNManager.h"
#include "CNReg.h"

//!Data Status
typedef enum{
    DATA_NO_CHANGES,           //!< No changes
    DATA_IS_CONNECTED,         //!< Data channel is connected
    DATA_IS_DISCONNECTED,      //!< Data channel is disconnected
} DataConnStatus;

/** Data Init.
  This function has to be called prior to dataTick
 */
void cnDataInit();

/** Loop data module
  \param lib  pointer to CN library
  \param regStatus for registration status
  \param dataStatus [output] data status
  \return CNResp
 */
CNResp cnDataLoop(CNLib* const lib, RegStatus regStatus, DataConnStatus* const dataStatus);

/** Register (Attach) the MT to the GPRS service.
 This function can be called at any time.
   \param enabled if true data connection is requested, if false not.
 */
void cnDataEnable(bool enabled);

/** Reset
 */
void cnDataReset();

/** Set parameters for the GPRS service.
If Apn parameters are not set, the internal APN info database will be used.
 \param apn the of the network provider e.g.
 \param apn the of the network provider e.g. "internet" or "apn.provider.com"
 \param username is the user name text string for the authentication phase
 \param password is the password text string for the authentication phase
 \param auth is the authentication mode (CHAP,PAP,NONE or DETECT)
 */
void cnDataSetupApn(const char* apn, const char* username, const char* password);
