//------------------------------------------------------------------------------------
/* This example was tested on C027-U20 and C027-G35 with the on board modem. 
   
   Additionally it was tested with a shield where the SARA-G350/U260/U270 RX/TX/PWRON 
   is connected to D0/D1/D4 and the GPS SCL/SDA is connected D15/D15. In this 
   configuration the following platforms were tested (it is likely that others 
   will work as well)
   - U-BLOX:    C027-G35, C027-U20, C027-C20 (for shield set define C027_FORCE_SHIELD)
   - NXP:       LPC1549v2, LPC4088qsb
   - Freescale: FRDM-KL05Z, FRDM-KL25Z, FRDM-KL46Z, FRDM-K64F
   - STM:       NUCLEO-F401RE, NUCLEO-F030R8
                mount resistors SB13/14 1k, SB62/63 0R
*/
#include "GPS.h"
#include "MDM.h"
#include "CNManager/CNManager.h"
//------------------------------------------------------------------------------------
// You need to configure these cellular modem / SIM parameters.
// These parameters are ignored for LISA-C200 variants and can be left NULL.
//------------------------------------------------------------------------------------
//! Set your secret SIM pin here (e.g. "1234"). Check your SIM manual.
#define SIMPIN      NULL
/*! The APN of your network operator SIM, sometimes it is "internet" check your 
    contract with the network operator. You can also try to look-up your settings in 
    google: https://www.google.de/search?q=APN+list */
#define APN         NULL
//! Set the user name for your APN, or NULL if not needed
#define USERNAME    NULL
//! Set the password for your APN, or NULL if not needed
#define PASSWORD    NULL 
//------------------------------------------------------------------------------------


//handler function
void mngHandler(MngEvents ev, void* p){
    if (ev == MNG_EV_IDLE){
        MDMSerial* mdm = cnGetMDM();
        MDMParser::DevStatus devStatus = {};
        
        printf("Handler:: Device has been inited correctly\r\n");
        getDevStatus(&devStatus);
        mdm->dumpDevStatus(&devStatus);        
    }else if (ev == MNG_EV_DATA_UP){
        MDMParser::NetStatus netStatus = {};
        MDMSerial* mdm = cnGetMDM();
        
        printf("Handler:: DATA is now UP\r\n");
        getNetStatus(&netStatus);
        mdm->dumpNetStatus(&netStatus);                   
        //Token can be released from u-blox site, when you got one replace "TOKEN" below 
        //if (!mdm.cellLocSrvTcp("TOKEN"))
        if (!mdm->cellLocSrvTcp("c_vCHm7ifUWKlj3M2t0Bhw"))
            mdm->cellLocSrvUdp();        
        mdm->cellLocConfig(1);   // Deep scan mode
        mdm->cellLocUnsol(1);
    }
    else if (ev == MNG_EV_DATA_DOWN){
        MDMParser::NetStatus netStatus = {};
        MDMSerial* mdm = cnGetMDM();
        
        printf("Handler:: DATA is now DOWN\r\n");
        getNetStatus(&netStatus);
        mdm->dumpNetStatus(&netStatus);                 
    }
}

int main(void)
{    
    const int wait = 100;
    const int timeoutMargin = 5; // seconds
    const int submitPeriod = 40; // 1 minutes in seconds
    unsigned int j = submitPeriod * 1000/wait;
    bool cellLocWait = false;     
    GPSI2C gps; 
    
    printf("Main::CM\r\n");
    cnInit();
    cnSetApn(APN, USERNAME, PASSWORD);
    cnSetSimPin(SIMPIN);
    cnSetDebug(3);    
    cnRegHandler(mngHandler);
     
     while (true){
       if (cnIsDataUp()){
           printf("Main:: DATA is UP\r\n");
           MDMSerial* mdm = cnGetMDM();
           if (j++ == submitPeriod * 1000/wait) {   
                j=0;
                printf("CellLocate Request\r\n");
                if (mdm->cellLocRequest(MDMParser::CELL_HYBRID, submitPeriod-timeoutMargin, 1,MDMParser::CELL_MULTIHYP, 2))
                    cellLocWait = true;
            }                  
            if (cellLocWait && mdm->cellLocGetExpRes()>0 && mdm->cellLocGetRes() == mdm->cellLocGetExpRes()){   
                MDMParser::CellLocData loc;  
                cellLocWait = false;     
                for(int i=0; i < mdm->cellLocGetRes(); i++){
                    mdm->cellLocGetData(&loc, i);                        
                    printf("CellLocate position received number %d, sensor_used: %d\r\n", i, loc.sensor );           
                    printf("  latitude: %0.5f, longitude: %0.5f, altitute: %d\r\n", loc.latitude, loc.longitude, loc.altitutude);
                    if (loc.sensor == 1)
                        printf("  uncertainty: %d, speed: %d, direction: %d, vertical_acc: %d, satellite used: %d \r\n", loc.uncertainty,loc.speed,loc.direction,loc.verticalAcc,loc.svUsed);                                      
                }
            }
            else if (cellLocWait && (j%10 == 0 ))
                printf("Waiting for CellLocate...\r\n");        
         }
         cnLoop();
         wait_ms(30);
     }
     
    gps.powerOff();
    cnSetPower(false);
    return 0;
}