#include "mbed.h"
#include "C027.h"
#include "UbloxUSBGSMModem.h"
#include "UbloxUSBCDMAModem.h"

#include "Websocket.h"

C027 c027;

void test(void const*)
{
    c027.mdmPower(true);
    c027.mdmReset();
    c027.mdmWakeup();
    UbloxUSBCDMAModem modem(NC, true, 1); // for LISA-C use the UbloxUSBCDMAModem instead
    modem.power(true);
    Thread::wait(1000);
    
    // See the output on http://sockets.mbed.org/demo/viewer
    Websocket ws("ws://sockets.mbed.org:443/ws/demo/rw");
    char msg[512] = {0};
    Timer t;
    t.start();
    
    int ret = modem.connect("internet"); // eventaully set another apn here
    if(ret) {
        printf("Could not connect\n");
        return;
    }

    bool c = ws.connect();
    printf("Connect result: %s\n", c?"OK":"Failed");

    for(int i = 0; i < 10000; i++) 
    {
        ws.connect();
        // create json string with acc/tmp data
        sprintf(msg, "Testing mbed Websockets Loop: %d", i);
        ws.send(msg);    
        wait(0.5f);
        memset(msg, 0, 512);
        
        if (ws.read(msg))
        {
            printf("rcv: %s\r\n", msg);
        }
        else
        {
            printf("Loop %d ws.read() returns 0\n \t %s, line %d @ %6.2f seconds\n", i, __FILE__, __LINE__, t.read());
            wait(5.0f);
        }
        ws.close();

    }

    modem.disconnect();
    c027.mdmPower(false);

    while(1) {
    }
}


int main()
{
    Thread testTask(test, NULL, osPriorityNormal, 1024 * 4);
    DigitalOut led(LED); // on rev A you should reasign the signal to A0
    while(1) {
        led=!led;
        Thread::wait(1000);
    }

    return 0;
}
