#include "mbed.h"
#include "C027.h"

#define NL      "\r\n"
#define T_RETRY 1

int main() {
    C027 c027;
    Serial pc(USBTXD, USBRXD); 
    pc.baud(115200);
    
    CAN can(CANRD, CANTD);
    can.frequency(500000);
    DigitalOut canS(CANS);
    canS = 0;
    CANMessage msg;
    
    Ethernet eth;
    bool ethLink = false;
    int len;
    
    printf(NL NL);
    printf("TestVer = \"" __DATE__ " " __TIME__ "\"" NL);
     
    while (1)
    {
        if (can.read(msg))
        {
            printf("Can: id %03X, len %d, data \"%.*s\"" NL, msg.id, msg.len, msg.len, msg.data);
            can.write(msg);
        }
        bool link = eth.link();
        if (ethLink ^ link)
        {
            printf("Eth: link %s" NL, link ? "OK" : "ERROR");
            ethLink = link;
        }
        if (link && ((len = eth.receive()) > 0))
        {
            char data[256];
            len = eth.read(data,len);
            printf("Eth: len %d, data \"%.*s\"" NL, len, len, data);
            eth.write(data, len);
            eth.send();
        }
        wait_ms(1);
    }
}
