#include "mbed.h"
#include "C027.h"
#include "WANDongle.h"
#include "USBSerialStream.h"
#include "UbloxCDMAModemInitializer.h"
#include "UbloxGSMModemInitializer.h"

int main() 
{
    C027 c027;
    c027.mdmUsbEnable(true);
    c027.mdmPower(true);
        
    // open the mdm serial port
    WANDongle mdmDongle;
    USBSerialStream mdmStream(mdmDongle.getSerial(1/* the CDC usually 0 or 1, LISA-C requires CDC1*/));
    USBHost* host = USBHost::getHostInst();
    mdmDongle.addInitializer(new UbloxCDMAModemInitializer(host));
    mdmDongle.addInitializer(new UbloxGSMModemInitializer(host));
   
    // open the PC serial port and (use the same baudrate)
    Serial pc(USBTX, USBRX);
    pc.baud(MDMBAUD);
    
    while (1)
    {
        uint8_t buf[64];
        size_t len;
        int i;
        if (!mdmDongle.connected())
        {
            mdmDongle.tryConnect();
        }
        else
        {
            // transfer data from pc to modem
            len = mdmStream.space();
            if (len>0)
            {
                if (len > sizeof(buf))
                    len = sizeof(buf);
                for (i = 0; (i < len) && pc.readable(); )
                    buf[i++] = pc.getc();
                if (OK == mdmStream.write(buf, i))
                    /* what to do here ?*/;
            }
            // transfer data from modem to pc
            len = mdmStream.available();
            if ((len>0) && pc.writeable())
            {
                if (len > sizeof(buf))
                    len = sizeof(buf);
                if (OK == mdmStream.read(buf, &len, len))
                {
                    for (i = 0; (i < len); )
                        pc.putc(buf[i++]);
                }
            }
        }
    }
}
