#include "mbed.h"
#include "C027.h"

int main() 
{
    C027 c027;
    c027.mdmPower(true);
    
    // open the mdm serial port
    Serial mdm(MDMTXD, MDMRXD);
    mdm.baud(MDMBAUD);
    
    // open the PC serial port and (use the same baudrate)
    Serial pc(USBTX, USBRX);
    pc.baud(MDMBAUD);
    
    while (1)
    {
        // transfer data from pc to modem
        if (pc.readable() && mdm.writeable())
            mdm.putc(pc.getc());
        // transfer data from modem to pc
        if (mdm.readable() && pc.writeable())
            pc.putc(mdm.getc());
    }
}
