#include "mbed.h"
#ifdef TARGET_UBLOX_C027
 #include "C027_api.h"
#else
 #error "This example is targeted for the C027 platform"
#endif

/* This example is establishing a transparent link between 
   the mbed serial port and the serial communication interface 
   of the GPS. 
   
   For a more advanced driver for the GPS or Modem(MDM) please 
   look at the follwing library and example:
   C027_Support Library 
     http://mbed.org/teams/ublox/code/C027_Support/
   C027_Support Example
     http://mbed.org/teams/ublox/code/C027_SupportTest/
*/
int main() 
{
    c027_gps_powerOn();
    int baud = GPSBAUD;
    
    // open the gps serial port
    Serial gps(GPSTXD, GPSRXD);
    gps.baud(baud);
    
    // open the PC serial port and (use the same baudrate)
    Serial pc(USBTX, USBRX);
    pc.baud(baud);
    
    while (1)
    {
        // transfer data from pc to gps
        if (pc.readable() && gps.writeable())
            gps.putc(pc.getc());
        // transfer data from gps to pc
        if (gps.readable() && pc.writeable())
            pc.putc(gps.getc());
    }
}
