#include "mbed.h"
#ifdef TARGET_UBLOX_C027
 #include "C027_api.h"
#else
 #error "This example is targeted for the C027 platform"
#endif

/* This example is establishing a transparent link between 
   the mbed serial port and the I2C communication interface 
   of the GPS. 
   
   For a more advanced driver for the GPS or Modem(MDM) please 
   look at the follwing library and example:
   C027_Support Library 
     http://mbed.org/teams/ublox/code/C027_Support/
   C027_Support Example
     http://mbed.org/teams/ublox/code/C027_SupportTest/
*/
int main()
{
    Timer tmr;
    tmr.start();
    c027_gps_powerOn();

    // open the gps i2c port
    I2C gps(GPSSDA, GPSSCL);
    gps.frequency(100000);

    // open the PC serial port and (use the same baudrate)
    Serial pc(USBTX, USBRX);
    pc.baud(GPSBAUD);
    
    int s = 0;
    int i = 0;
    int o = 1; 
    char in[1024];
    char out[1024] = { 0xFF/*STREAM_REG*/, 0x00 /* ... */ };
    while (1) 
    {
        // transfer data from pc to gps
        if (pc.readable() && (o < sizeof(out)))
            out[o++] = pc.getc();
        if (pc.writeable() && i < s) 
            pc.putc(in[i++]);
    
        if (tmr.read_ms() > 50)
        {
            const char r = 0xFD /*LENGTH_REG*/; 
            unsigned char sz[2];
            if (0 == gps.write(GPSADR,&r,sizeof(r), true))
            {
                if (0 == gps.read(GPSADR,(char*)sz,sizeof(sz),true))
                {
                    int b  = (int)sz[0];
                    b *= 256;
                    b += sz[1];
                    if (i == s)
                        i = s = 0;
                    if (b > sizeof(in)-s) 
                        b = sizeof(in)-s;
                    if (b > 0) 
                    {
                        if (0 == gps.read(GPSADR,&in[s],b,true))
                            s += b;
                    }
                }
            }
            gps.stop();
            if (o > 1)
            {
                if (0 == gps.write(GPSADR,out,o))
                    o = 0;
            }
            tmr.reset();
        }
    }
}
