#include "mbed.h"
#include "C027.h"
#include "GPS.h"
#include "SerialPipe.h"

#include "SeeedStudioTFTv2.h"
#include "Arial12x12.h"
#include "Arial24x23.h"
#include "Arial28x28.h"
#include "font_big.h"

#include "UbloxModem.h"

void ubxLogo(SPI_TFT_ILI9341* tft, int x0/*160*/, int y0/*160*/, int r)
{
    int i1=r/8, i1_5=r*3/16, i2=r*2/8, i3=r*3/8, 
        i4=r*4/8,  i5=r*5/8, i6=r*6/8, i7=r*7/8;
    // the ball
    tft->fillcircle(x0,    y0,        r, Red);
    // the dot
    tft->fillcircle(x0-i2, y0-i3,  i1_5, White);
    // the u
    tft->fillcircle(x0+i4, y0+i3,    i3, White);
    tft->fillcircle(x0+i4, y0+i3,    i1, Red);
    tft->fillrect(  x0+i1, y0-i1, x0+i3, y0+i3, White);
    tft->fillrect(  x0+i3, y0-i1, x0+i5, y0+i3, Red);
    tft->fillrect(  x0+i5, y0-i1, x0+i7, y0+i6, White);
}

#define info(...) \
    TFT.locate(0,5), \
    TFT.fillrect(0,0,320,35,White), \
    TFT.printf(__VA_ARGS__)

int main() 
{
    SeeedStudioTFTv2 TFT(A3, A1, A2, A0, 
                         D11, D12, D13, 
                         D5/*tft cs*/, D6/*tft dc*/, D7/*backlight*/, 
                         D4/*sd cs*/);
    TFT.setBacklight(true);
    TFT.set_font((unsigned char*) Arial12x12);  // select the font
    TFT.set_orientation(3);
    //TFT.calibrate();          // calibrate the touch
    TFT.background(White);    // set background to black
    TFT.foreground(Black);    // set chars to white
    TFT.cls();                // clear the screen
    ubxLogo(&TFT, 160, 120, 80);
    TFT.locate(70,220);
    TFT.printf("u-blox C027-C20/U20/G35");

    C027 c027;
    //c027.mdmUsbEnable(true); // disable this is you plan to use the Serial port on LISA-C
    c027.mdmPower(true);
    c027.gpsPower(true);
    
    GPSSerial gps;
    //UbloxUSBModem modem; // LISA-U or LISA-C, don't forget to call the mdmUsbEnable above
    UbloxSerModem modem;   // LISA-U, LISA-C or SARA-G
    size_t count;
    
    #define MY_IMEI "+41799613242"    
    info(" Cellular Modem\n IMEI: %s", MY_IMEI);
    
    char num[17] = "", msg[160+1] = "";
    char link[160] = "";
    clock_t c = clock();
    while(true)
    {
        clock_t n = clock();
        if ((n - c) > CLOCKS_PER_SEC) // every 3 seconds
        {
            int rssi;
            LinkMonitor::REGISTRATION_STATE state;
            LinkMonitor::BEARER bearer;
            if (!modem.getLinkState(&rssi, &state, &bearer))
            {
                 const char* sState[] = 
                 { "      ", 
                   "REG.  ", 
                   "DENIED", 
                   "NO NET", 
                   "HOME  ", 
                   "ROAM  " };
                 const char* sBearer[] = 
                 { "         ", 
                   "GSM 2G   ", 
                   "EDGE 2.5G", 
                   "UMTS 3G  ", 
                   "HSPA 3G+ ", 
                   "LTE 4G   " };
                 TFT.locate(0,175);
                 TFT.printf(" %s\n"
                            " %s\n"
                            " %idBm ", sBearer[bearer],sState[state],rssi);
            }  
            if((state >= LinkMonitor::REGISTRATION_STATE_HOME_NETWORK) && !modem.getSMCount(&count) && (count > 0))
            {
                if(!modem.getSM(num, msg, sizeof(msg)))
                {
                    info(" From: %s\n SMS:%s", num, msg);
                    if (0 == strcmp(msg, "Where are you?") && *link)
                    {
                        modem.sendSM(num, link);
                    }
                }
            }
            c = n;
        }
        point p;
        if (TFT.getPixel(p) && (p.y < 35) && *num)
        {
            const char* txt = "Hello from C027 :)";
            if (OK == modem.sendSM(num, txt))
            {
                info(" To: %s\n SMS:%s", num, txt);
                *num = 0;
            }
        }
        int ret;
        while ((ret = gps.getMessage(msg, sizeof(msg))) > 0)
        {
            int len = LENGTH(ret);
            if (PROTOCOL(ret) == NMEA && !strncmp("$GPGLL", msg, 6))
            {
                double la = 0, lo = 0;
                char cLa = 0, cLo = 0, ch = 0;
                TFT.fillrect(220,175,320,210,White);
                TFT.locate(220,175);
                TFT.printf("      GPS");
                if (gps.getNmeaItem(1,msg,len,la) && gps.getNmeaItem(2,msg,len,cLa) && 
                    gps.getNmeaItem(3,msg,len,lo) && gps.getNmeaItem(4,msg,len,cLo) && 
                    gps.getNmeaItem(6,msg,len,ch) && ch == 'A')
                {
                    la *= 0.01;
                    lo *= 0.01;
                    int iLa = (int)la;
                    int iLo = (int)lo;
                    la = (la - iLa) / 0.6 + iLa;
                    lo = (lo - iLo) / 0.6 + iLo;
                    if (cLa == 'S') la = -la;
                    if (cLo == 'N') lo = -lo;
                    
                    TFT.locate(220,187);
                    TFT.printf("%11.6f ", la);
                    TFT.locate(220,199);
                    TFT.printf("%11.6f ", lo);
                    sprintf(link, "https://maps.google.com/?q=%.5f,%.5f", la, lo); 
                }
            }
        }
    }
}
