/*  Platform source file, for the u-blox C27-C20/U20/G35 
*   mbed Internet of Things Starter Kit
*   http://mbed.org/platforms/u-blox-C027/
*   
*/
#if defined(TARGET_UBLOX_C027)
 
#include "C027.h"
 
C027::C027() :
    // Modem
    mdmEn(MDMEN, 0),            // LDO off
    mdmRst(MDMRST, 1),          // not reset
    mdmPwrOn(MDMPWRON, 1),      // Power On idle
    mdmLvlOe(MDMLVLOE, 1),      // GPIO/Serial velel shifters off
    mdmILvlOe(MDMILVLOE, 0),    // I2C Level shifter off
    mdmUsbDet(MDMUSBDET, 0),    // USB not used 
    // GPS
    gpsEn(GPSEN, 0),            // LDO off
    gpsRst(GPSRST, 1)           // not reset
{
    DigitalOut led(LED, 0);         // start with leds off
    DigitalOut mdmRts(MDMRTS, 0);   // make sure that rts is low
    
    gpsIsEnabled = false;
    mdmIsEnabled = false;
    mdmUseUsb = false;
}

void C027::mdmPower(bool enable)
{
    if (!mdmIsEnabled && enable) // enable modem
    {
#ifdef C027_REVA
        // we need the gps ldo for the level shifters of the modem
        if (!gpsIsEnabled)
            gpsEn = 1;  // LDOEN(gps): 0=off -> 1=on
#endif
        mdmLvlOe  = 1;  // LVLEN:  1=disabled
        mdmILvlOe = 0;  // ILVLEN: 0=disabled
        // turn on the mode by enabling power with power on pin low and correct USB detect level
        mdmUsbDet = mdmUseUsb ? 1 : 0;  // USBDET: 0=disabled, 1=enabled
        mdmPwrOn  = 0;  // PWRON:  0=turn on
        mdmEn     = 1;  // LDOEN:  1=on
        wait_ms( 1);    //         wait until supply switched off
        // mnake sure reset is also off
        mdmRst    = 1;  // RESET:  0=not reset
        wait_ms(300);   //         power on sequence is triggered by keeping reset 50ms-300ms low
        mdmPwrOn  = 1;  // PWRON:  0=turn on -> 1=idle
        mdmIsEnabled = true;
        // the interfaces of the modem should be fully ready after a certain period
        // LISA-U200  5000ms
        // SARA-G350  3000ms
        // LISA-C200       
        wait_ms(1000);
        // now we can safely enable the level shifters
        mdmLvlOe  = 0;  // LVLEN:  0=enabled (uart/gpio)
        if (gpsIsEnabled) 
            mdmILvlOe = 1; // ILVLEN: 1=enabled (i2c)
    }
    else if (mdmIsEnabled && !enable) // disable modem
    {
        mdmIsEnabled = false;
        // diable all level shifters
        mdmILvlOe = 0;  // ILVLEN: 0=disabled (i2c)
        mdmLvlOe  = 1;  // LVLEN:  1=disabled (uart/gpio)
        mdmUsbDet = 0;  // USBDET: 0=disabled
        // initiate power off sequence by setting PwnOn low for >1s
        mdmPwrOn  = 0;  // PWRON:  0=active
        wait_ms(1000);  //         send to sleep
        mdmPwrOn  = 1;  // PWRON:  0=active -> 1=idle
        // now we can savely switch off the ldo
        mdmEn     = 0;  // LDOEN:  1=on -> 0=off
#ifdef C027_REVA
        // the gps ldo may no longer be needed level shifters of the modem
        // so we switch it off if the gps is not enabled
        if (!gpsIsEnabled) 
            gpsEn = 0;  // LDOEN(gps): 1=on -> 0=off
#endif
    }
        
}

void C027::mdmUsbEnable(bool enable)
{
    mdmUseUsb = enable;
    if (mdmIsEnabled)
        mdmUsbDet = mdmUseUsb ? 1 : 0;
}

void C027::mdmReset(void)
{
    if (mdmIsEnabled)
    {
        mdmRst   = 0;   // RESET: 0=reset
        // power on sequence is triggered by reset low
        // LISA-U200   50ms
        // SARA-G350   50ms
        // LISA-C200  300ms
        wait_ms(300);
        mdmRst   = 1;   // RESET: 0=reset -> 1=operating
    }
}

void C027::mdmWakeup(void)
{
    if (mdmIsEnabled)
    {
        mdmPwrOn = 0;
        // wakeup the device by low pulse: 
        // LISA-U200 50-80us
        // SARA-G350     5ms
        // LISA-C200   300ms 
        wait_ms(300);   
        mdmPwrOn = 1;
    }
}

void C027::mdmSleep(void)
{
    if (mdmIsEnabled)
    {
        mdmPwrOn = 0;
        // going to sleep is triggerd by low pulse: 
        // LISA-U200  1000ms
        // SARA-G350     n/a
        // LISA-C200     n/a
        wait_ms(1000);  
        mdmPwrOn = 1;
    }
}

void C027::gpsPower(bool enable)
{
    if (!gpsIsEnabled && enable) // enable gps
    {
        // switch on power supply
        gpsEn    = 1;   // LDOEN: 0=off -> 1=on
        wait_ms(1);     //        wait until stable
        // make sure we are not in reset
        gpsRst   = 1;   // RESET: 0=reset -> 1=operating
        gpsIsEnabled = true;
        // the gps schould be fully ready after 50ms
        if (mdmIsEnabled) 
            mdmILvlOe = 1; // ILVLEN: 0=enabled (i2c)
    }
    else if (gpsIsEnabled && !enable) // diasble gps
    {
        gpsIsEnabled = false;
        mdmILvlOe = 0;   // ILVLEN: 0=disabled (i2c)
#ifdef C027_REVA
        // the gps ldo may have to remain enabled for the level shifters of the modem
        if (!mdmIsEnabled)  
            gpsEn  = 0;  // LDOEN: 1=on -> 0=off 
#else
        gpsEn     = 0;   // LDOEN: 1=on -> 0=off 
#endif
    }
}

void C027::gpsReset(void)
{
    if (gpsIsEnabled)
    {
        gpsRst   = 0;    // RESET: 0=reset,1=operating
        wait_ms(1);
        gpsRst   = 1;    // RESET: 1=operating,0=reset
    }
}
#endif
