#include "mbed.h"

Serial pc(USBTX, USBRX);
Serial gps(PTC15, PTC14);  // UART4

DigitalOut RESET(PTC9);
DigitalOut WAKEUP(PTC7);
DigitalOut POWER(PTC8);
 
void setupGPS()
{
    RESET = 1;
    wait_ms(300);        
    RESET = 0;
    
    // WAKEUP signal will be issued whe ON_OFF signal goes high
    WAKEUP = 0;
    wait_ms(100);             
    WAKEUP = 1;
    wait(2.0f);
    WAKEUP = 0;
    wait_ms(100);
    
    POWER = 1;
    wait_ms(200);
    POWER = 0;
    
    gps.baud(4800);
}

char dataRaw[100];
short nmeaReady;
int count;

int main()
{        
    pc.printf("Hello uBerry\r\n");
    
    setupGPS();

    while (1) 
    { 
        if(gps.readable())
        {                            
            //pc.putc(gps.getc());            
            count = 0;
            dataRaw[count] = gps.getc();                            
            count++;          
            pc.printf((char*)dataRaw);  
        } else {
            
        }
    }
}