/** 9.3 Licht zeitgesteuert Ein- und Ausschalten, z.B. h:m:45 Ein, h:m:50 Aus.
 * Informationen um Zeit zu holen von http://stackoverflow.com/questions/997946/how-to-get-current-time-and-date-in-c
*/
#include "mbed.h"
#include "EthernetInterface.h"
#include "NTPClient.h"

EthernetInterface eth;
NTPClient ntp;

// Licht
DigitalOut led( D10 );

int main()
{
    // Ethernet Interface Initialisieren
    printf("Initialize Ethernet\n" );
    eth.init();
    eth.connect();

    // Zeit vom Time Server holen
    printf("Trying to update time...\r\n");
    if (ntp.setTime("1.pool.ntp.org") == 0) 
    {
        printf("Set time successfully\r\n");
        time_t ctTime;
        ctTime = time(NULL);
        printf("Time is set to (UTC): %s\r\n", ctime(&ctTime));
    } 
    else
        printf("Error\r\n");
    eth.disconnect();

    // display the time
    while(1) 
    {
        time_t seconds = time(NULL);
        struct tm * now = localtime( & seconds );
        printf( "%d.%d.%d %2d:%2d:%2d\n", now->tm_mday, now->tm_mon + 1, now->tm_year + 1900, now->tm_hour, now->tm_min, now->tm_sec );
        
        // h:m:15 Ein, h:m:20 Aus.
        if  ( now->tm_sec >= 15 && now->tm_sec <= 20 )
            led = 1;
        // h:m:45 Ein, h:m:50 Aus.
        else if  ( now->tm_sec >= 45 && now->tm_sec <= 50 )
            led = 1;
        else 
            led = 0;

        wait(1);
    }
}