/** 9.1 Holen der Zeit vom Internet und interne Uhr setzen 
 * Informationen um Zeit zu holen von http://stackoverflow.com/questions/997946/how-to-get-current-time-and-date-in-c
*/
#include "mbed.h"
#include "EthernetInterface.h"
#include "NTPClient.h"

EthernetInterface eth;
NTPClient ntp;

int main()
{
    // Ethernet Interface Initialisieren
    printf("Initialize Ethernet\n" );
    eth.init();
    eth.connect();

    // Zeit vom Time Server holen
    printf("Trying to update time...\r\n");
    if (ntp.setTime("1.pool.ntp.org") == 0) 
    {
        printf("Set time successfully\r\n");
        time_t ctTime;
        ctTime = time(NULL);
        printf("Time is set to (UTC): %s\r\n", ctime(&ctTime));
    } 
    else
        printf("Error\r\n");
    eth.disconnect();

    // display the time
    while(1) 
    {
        time_t seconds = time(NULL);
        struct tm * now = localtime( & seconds );
        printf( "%d.%d.%d %2d:%2d:%2d\n", now->tm_mday, now->tm_mon + 1, now->tm_year + 1900, now->tm_hour, now->tm_min, now->tm_sec );
        wait(1);
    }
}