/** 8.2 Setzen der Zeit, mittels der Seriellen Schnittstelle und Ausgabe Stunden und Minuten auf dem Display.
 * Beispiel von http://developer.mbed.org/blog/entry/103/
 * Informationen um Zeit zu holen von http://stackoverflow.com/questions/997946/how-to-get-current-time-and-date-in-c
*/
#include "mbed.h"

#include "DigitDisplay.h"

DigitDisplay display(PTC5, PTC7);

int main()
{
    // get the current time from the terminal
    struct tm t;
    printf("Enter current date and time:\n");
    printf("YYYY MM DD HH MM SS[enter]\n");
    scanf("%d %d %d %d %d %d", &t.tm_year, &t.tm_mon, &t.tm_mday
          , &t.tm_hour, &t.tm_min, &t.tm_sec);

    // adjust for tm structure required values
    t.tm_year = t.tm_year - 1900;
    t.tm_mon = t.tm_mon - 1;

    // set the time
    set_time( mktime(&t) );

    // display the time
    while(1) 
    {
        time_t seconds = time(NULL);
        struct tm * now = localtime( & seconds );
        printf( "%d.%d.%d %2d:%2d:%2d\n", now->tm_mday, now->tm_mon + 1, now->tm_year + 1900, now->tm_hour, now->tm_min, now->tm_sec );

        display.write(0, now->tm_min / 10);
        display.write(1, now->tm_min % 10);
        display.write(2, now->tm_sec  / 10);
        display.write(3, now->tm_sec  % 10);

        wait(1);
    }
}