/** 8.1 Kombiniert das Übung 6.1 Licht bei Dämmerung einschalten 
        mit RPC Variable um die Sensordaten via Client abzufragen.
*/
#include "mbed.h"
#include "rtos.h"
#include "EthernetInterface.h"
#include "HTTPServer.h"
#include "mbed_rpc.h"

EthernetInterface eth;

// Servo + aktuelle Werte
AnalogIn   light( A1 );
DigitalOut d10( D10 );
float val1;
Ticker sensors;

// Update Sensor Werte
void updateVal()
{
    // Variable RPC zur Verfuegung stellen
    val1 = light;
    
    // Licht bei Daemmerung einschalten
    if  ( light < 0.04f )
        d10 = 1;
    else 
        d10 = 0;
}

int main()
{
    printf("RPC HTTP Server\n");
    eth.init(); //Use DHCP
    eth.connect();
    printf("IP Address is %s\n\r", eth.getIPAddress());
    
    sensors.attach( &updateVal, 1.0 );
    
    // Objekte
    RPCVariable<float> rpcVal1( &val1, "light" );

    // Handler
    HTTPServerAddHandler<RPCHandler>("/rpc");
    
    // Start HTTP Server auf Port 80
    printf( "Starte Server\n" );
    HTTPServerStart(80);
}

