/** 6.13 Schrittmotor bis zum Endschalter laufen lassen, Nullpunkt setzen, 10 x 100 Schritte vorwärts 
         und in einem Lauf zurück auf die Nullposition. Zusätzlich einen Button als Notaus (Soforthalt) vorsehen.
         Anwendung: 3D Drucker, Plotter, CNC Fräse.
 */

#include "mbed.h"
#include "StepperMotorUni.h"

// Schrittmotor
StepperMotorUni motor( PTB18, PTB19, PTC1, PTC8 );
// Endabschalter 
DigitalIn home( A3, PullUp );
// Notstop
DigitalIn stop ( PTC9, PullUp );

int main()
{
    // Motordrehzahl
    printf( "Schrittmotor Test\n" );
    motor.set_pps( 300 );

    while ( 1 ) 
    {
        printf( "vorwaerts\n" );
        int steps = 10;
        for ( int i = 0; i < 2048; i += steps )
        {
            motor.move_steps( steps );
            if  ( home == 0 )
                break;
            if  ( stop == 0 )
                return( -1 ); 
            wait( 0.1 );                
        }

        printf( "rueckwaerts\n" );
        motor.move_steps( -1024 );
        wait( 5.0 );
        
        printf( "in die Mitte\n" );
        motor.move_steps( 512 );
        wait( 2.5 );        
    }
}
