#include "mbed.h"
#include "C12832_lcd.h"
Serial pc (USBTX,USBRX);
Timer sRandTime;
 
bool newEvent =false; 
uint8_t event=0, state=0;
 
InterruptIn iiJsUp(p15);        //alle Funktionen von Joystick initialisieren
DigitalIn diJsUp(p15);
InterruptIn iiJsCenter(p14);
DigitalIn diJsCenter(p14);




char calcOp;              
int value1, value2, result;     // variablen fürs Rechnen festlegen, initialisierung
C12832_LCD lcd;
 

 
// prototypes                   //festgelegte Funktionen werden hier abgearbeitet
void noFunction();              //keine Funktion
void selectOp();


  

 
/****************************************************/
/* Tabelle fuer die naechsten Zustaende bei Eingabe */
/****************************************************/
uint8_t nextstate_tab[1][3]=
// current event/  present state 0  1  2  3
//----------------------
/* Event 0 (Joystick UP)    */{{ 0,1,0 }};  // next


/*************************************************************/
/* Tabelle fuer Aktionsroutinen fuer die Zustaende bei Input */ 
/*************************************************************/
//                           p r e s e n t    s t a t e  
void (*action[1][3])()= //      0        1               2           3    
/* event 0 */       {{ noFunction,selectOp,noFunction}};        


 
// action routines              //Funktionen erstellen,was darin passiert




void noFunction()
{
    
}
uint8_t debounce(DigitalIn myIn)  
{
    #define LEVEL_CHECKS 16
    #define MAX_LOOPS 80                // stoppt das Überprüfen des Prellen nach max. MAX_LOOPS Durchläufen
    unsigned char port_buffer;
    unsigned char debounceCounter = 0;
    uint8_t loopCounter = 0;
    
    do
    {
        port_buffer = myIn;
        wait_us(100);
        loopCounter++;
        if(myIn == port_buffer)
          debounceCounter++;    // mindestens 'LEVEL_CHECKS' Abtastungen in Folge: gleicher Pegel
        else
          debounceCounter = 0;      
    }
    while ((debounceCounter <= LEVEL_CHECKS) && (loopCounter <= MAX_LOOPS));
    return loopCounter;
}
int myRand(int min, int max) 
{
    return rand()%(max-min+1)+min;
}

 void selectOp()
{
        debounce(diJsUp);
        event=1;
        newEvent = true;
        value1 = myRand(0, 100);
        value2 = myRand(-50,50);
        pc.printf("\nRandom Calculator wartet auf Eingabe eines OPERATORS:\n");
        pc.scanf("%c",&calcOp); 
        if (calcOp == '+')
        {
        
        result = value1 + value2;
        pc.printf("Der gewaehlte Operator %c Ergebnis: %d %c %d  = %d             \n", calcOp, value1, calcOp,value2,result);
        }
        if (calcOp == '-')
        {
        result = value1 - value2;
        pc.printf("Der gewaehlte Operator %c Ergebnis: %d %c %d  = %d             \n", calcOp, value1, calcOp,value2,result);
        }
        if (calcOp == '*')
        {
        result = value1 * value2;
        pc.printf("Der gewaehlte Operator %c Ergebnis: %d %c %d  = %d             \n", calcOp, value1, calcOp,value2,result);
        }
        if (calcOp == '/')
        {
        result = value1 / value2;
        pc.printf("Der gewaehlte Operator %c Ergebnis: %d %c %d  = %d             ", calcOp, value1, calcOp,value2,result);
        pc.printf("Rest %d",value1%value2);            
        }
        if (calcOp == '/' && value2 == 0)
        {
        pc.printf("Durch 0 kann man nicht dividieren\n");
        }
        
        
        pc.printf("Random Calculator mit Joystick UP erneute starten\n");
        debounce(diJsUp);
        event=0;
        newEvent = true;
        
}    
 
 
 
 
void init() {               //hier wird alles initialisiert
    sRandTime.start();
    newEvent = false;
    state=0; 
    event=0;
    iiJsUp.rise(&selectOp); 
}



int main()          //Hauptprogramm 
{
    init();
    pc.printf("Random Calculator mit der Taste JoyStick UP starten:Christoph Unger");


    while(1) 
    {
        if (newEvent) 
        {
             srand(sRandTime.read_us());
            
            newEvent=false;
            (*action[event][state])();                      // line 1 for executing sm: run action routine
            state = nextstate_tab[event][state];    // line 2 for executing sm: run state transition 
           
        }
    }
      
}