#include "parser.h"
#include <cctype>

// functions
char* normalizeStr(char* theArr) {
    int i=0;
    string myStr, bestStr;
    myStr.assign(theArr);
    while (myStr[i]) {  // replace all white spaces into spaces (0x20)
        if (isspace(myStr[i])) 
            myStr[i]=' ';
        i++;
    }
    myStr.erase(0, myStr.find_first_not_of(" "));  // remove leading spaces 
    myStr.erase(myStr.find_last_not_of(" ")+1);  // remove trailing spaces
    strcpy(theArr, myStr.c_str());
    int x = 0;
    for (i=0; i<=myStr.length(); i++) {
        theArr[x] = myStr[i]; 
        if (x>=1) {
            if ((theArr[x] == ' ') && (theArr[x-1] == ' ')) // reduce several spaces to one space
                x--;
            if ((theArr[x] == ';') && (theArr[x-1] == ' ')) // delete every space before ';'
                theArr[--x] = ';';
        } 
        x++;    
        if (theArr[x-1] == ';')             
            break; // ignore everything after ';' 
    }
    theArr[x] = '\0';
    if (x>1) {
     if ((theArr[0] == '/') && (theArr[1] == '/'))
        theArr[0] = 0;  // ignore comments 
    }
    return theArr;
}

bool getArg(int16_t myCom[], string myItem) { // keyword specific argument handling
    bool done=true;
    switch (myCom[0]) {
        case 1: // LEDS
            if (myItem[0] == 'E') myCom[1]=0x0F;
            else if (myItem[0] == 'A') myCom[1]=0;
            else myCom[1] = (int16_t)std::strtol(myItem.c_str(), NULL, 10);
            break;       
        case 2: // WAIT 
        case 3: // REPEAT
        case 4: // GOTO
            myCom[1] = (int16_t)std::strtol(myItem.c_str(), NULL, 10); 
            break;
            
            case 5: //END
            break;
            case 6: //NOP
            break;
            case 7:
            myCom[1] = (int16_t)std::strtol(myItem.c_str(), NULL, 10);//TONE
            break;  
            
       
        default: myCom[1]= myCom[0]*-1; done=false; break;
    }
//  printf("... getArg: myItem=<%s>;   %s %d\r\n", myItem.c_str(), keywords[myCom[0]].c_str(), myCom[1]); 
    return done;
}

bool parseLine(string line, int16_t command[]) { // parse a normalized command line
    bool done = false;
    int i=0;

    size_t pos = line.find_first_of(" ;");  // find first ' ' or ';' in string
    string theItem = line.substr(0, pos); 
    for (i=1; i <= validKeyWords; i++) {
        if (keywords[i].compare(theItem)==0) {  // compare keyword with keywords in list (array)
            command[0] = i;             // store no representation of the found keyword in command[0]
            if (line[pos] == ';') {
                done = true;
                command[1] = -101;  
            }
            else {
                line.erase(0, line.find_first_of(" ")+1); // remove keyword from string
                pos = line.find_first_of(";\r");    // error tolerant: if line is not completed with ';'; --> '\r\n' .. end of line
                if (pos >0) {
                    theItem = line.substr(0, pos); 
                    done = getArg(command, theItem);    // handling of a second arument depending on the keyword
                }
                else {
                    command[1] = -102;
                    done = false;
                }
            }
            break;  // keyword found
        }
    } // for
    return done;
}
