#include "mbed.h"
#include "parser.h"

#define LOCAL_FS "fs"
#define INTERP_FILE "/fs/STR1.txt"
#define NORM_FILE "/fs/interp1a.txt"

// global vars/objects
const string keywords[] = {"a-nix", "LEDS", "WAIT", "REPEAT", "GOTO", "END", "NOP","TONE" ,"z-nix"}; 
int validKeyWords;
uint8_t statusExecute;
BusOut myLeds(LED1, LED2, LED3, LED4);
LocalFileSystem fs(LOCAL_FS);
PwmOut speaker(p26);

uint8_t executeComLine(int16_t command[], uint16_t *lNo)
{   
    static int16_t repeatCounter = 0;
    uint8_t retVal = 0;
    printf("line %d: %s %d\r\n", *lNo, keywords[command[0]].c_str(), command[1]); 
    switch (command[0]) {
        case 1: // LEDS
            if (command[1] < UNVALID_ARG)
                retVal = ERROR_DEF;
            else            
                myLeds = command[1]; 
            break;
        case 2: // WAIT
            if (command[1] <= 0) 
                command[1] = 1234;
            wait_ms(command[1]);  
            break;  
        case 3: // REPEAT
            if (++repeatCounter < command[1])
                retVal = REPEAT_DEF; 
            break;
        case 4: // GOTO line
            if (command[1] < UNVALID_ARG)
                retVal = ERROR_DEF;
            else {
                *lNo = command[1];
                retVal = GOTO_DEF;
            }
            break;
        case 5: // END
            repeatCounter = 0; break;
            
            case 6: //NOP
            break;
            
            case 7: // TONE
                
               speaker.period(1.0/(float)command[1]);
                speaker= 0.5; 
                 wait(1);
                 speaker= 0.0;
                 wait(1);
                 break;
        default:
            printf("no valid command: %d = %s ... ERROR\r\n\r\n", command[0], keywords[command[0]].c_str());
            retVal = ERROR_DEF;
            break;
    }
    return retVal;
}

int main()
{
    char myArr [100];
    char* myStr;
    string argLine;
    int16_t comArray[4];
    uint16_t lineNo = 0, lineCnt;
    FILE *fp2rw;
    FILE *fp2read = fopen(INTERP_FILE,"r");

    fp2rw = fopen(NORM_FILE, "w"); // file name is LIMITED to 8 chars!!!
    validKeyWords = sizeof(keywords)/sizeof(*keywords) -2;
    printf("0) validKeyWords = %i\r\n", validKeyWords);

    if (fp2read != NULL) {
        while (fgets(myArr, sizeof myArr, fp2read) != NULL) {
            myStr = normalizeStr(myArr);
//            printf("a) myStr = <%s>\r\n", myStr);
            if (myStr[0] != 0)
                fprintf(fp2rw, "%s\r\n", myStr);
        }
        fclose(fp2rw);
        fp2rw = fopen(NORM_FILE, "r"); // because "w+" and "r+" don't work
//        printf("\r\nb) -- interpretation of Commands --\r\n\r\n");
        while (fgets(myArr, sizeof myArr, fp2rw) != NULL) { // while 1
            // printf("c) --> myArr = %s", myArr);
            argLine.assign(myArr);
            lineNo++;   // count lines
            if (parseLine(argLine, comArray)) { // parse the command line in normalized file interp1a.txt
                statusExecute = executeComLine(comArray, &lineNo); // interpret the command line using the prepared command array
                if (statusExecute == REPEAT_DEF) { 
                    rewind(fp2rw);  // do rewind if keyword is REPEAT
                    lineNo=0;
                }
                else if (statusExecute == GOTO_DEF) {
                    rewind(fp2rw);
                    lineCnt = 0; // start with line 1  
                    lineNo--; 
                    while (fgets(myArr, sizeof myArr, fp2rw) != NULL) { // while 2
                        lineCnt++;
                        if (lineCnt>=lineNo)
                            break; // break while 2; line found --> continue
                    }
                }
                else if (statusExecute == ERROR_DEF) {
                    printf("--> ERROR_DEF (%d) occurred in line = %d\r\n", statusExecute, lineNo);
                    break; // break while 1; stop executing   
                }
            } 
            else {
                printf("Interpreter Error in file interp1a.txt; line = %d: %s\r\n", lineNo, myArr);
            }
        }
    } else
        printf("Error opening file to read: %s\r\n", INTERP_FILE);

    fclose(fp2read);
    fclose(fp2rw);
    myLeds = 0x0A;
    while(1);   // endless loop; use reset to start programm again
}
