#include "mbed.h"

int main() {
    while(1) {

    }
}

// Eingang
DigitalIn ##( /*Pinbezeichnung*/ );
BusIn ##(/*Pinbezeichnung*/,/*Pinbezeichnung*/);

//Ausgang
DigitalOut ##( /*Pinbezeichnung*/ );
BusOut ##( /*Pinbezeichnung*/,/*Pinbezeichnung*/ );

//Ledbar mit 12 Leds
//         2^0     2^1   2^2
BusOut lb(P1_13, P1_12, P1_7, P1_6, P1_4, P1_3, P1_1, P1_0, LED4, LED3, LED2, LED1); 
//         D20     D19    D18  D17   D16   D15   D14   D13   D$    D3    D2    D1

//Interrupt 
//definieren
InterruptIn ##(/*Pinbezeichnung*/);
//Steigende Flanke
##.rise(&/*funktion die ausgeführt werden soll*/);
//Fallende Flanke
##.fall(&/*funktion die ausgeführt werden soll*/);


//Entprellung
uint8_t debounce(DigitalIn myIn)
{
#define LEVEL_CHECKS 8
#define MAX_LOOPS 30                // stoppt das Überprüfen des Prellen nach max. MAX_LOOPS Durchläufen
    unsigned char port_buffer;
    unsigned char debounceCounter = 0;
    uint8_t loopCounter = 0;
 
    do {
        port_buffer = myIn;
        wait_us(150);
        loopCounter++;
        if(myIn == port_buffer)
            debounceCounter++;    // mindestens 'LEVEL_CHECKS' Abtastungen in Folge: gleicher Pegel
        else
            debounceCounter = 0;
    } while ((debounceCounter <= LEVEL_CHECKS) && (loopCounter <= MAX_LOOPS));
    return loopCounter;
}


