#include "mbed.h"

// Modulname:   Zufallszahlen / Random      Version: 1.0   
// Funktion:    Erstellen von Zusatzzahlen
// Erstellt von: RN am: 2016-03-23

DigitalIn diJsUp(p15);
Serial pc(USBTX, USBRX);
Timer sRandTime;

void init() {
    sRandTime.start();
    pc.printf("\r\n\r\n >>- - - Zufallszahlen raten - - -<< \r\n");
    // http://www.cplusplus.com/reference/cstdlib/rand/
}


int myRand(int min, int max){
    return rand()%(max-min+1)+min;
}

int main()
{
    int iSecret, iGuess;
    init();

    while(1) {
        // initialize random seed:
        srand(sRandTime.read_us());
        //generate secret number between 6 and 16:
        // iSecret = rand() % 10;      // Wenn ich Zahlen zwischn 20 und 30 muss ich rechnen MAX - MIN also %11 (0 bis 10) + 20
        iSecret = myRand(6,16);
        pc.printf ("\r\n --> Errate die Zufallszahl zwischen  und 10): \r\n");
        pc.printf ("\r\n Zufallszahl = %i \r\n", iSecret);     
        
        do {
            pc.scanf ("%d",&iGuess);
            if (iSecret < iGuess) 
                pc.printf("Die Zahl ist kleiner als %d\r\n", iGuess);
            else if (iSecret > iGuess) 
                pc.printf("Die Zahl ist groesser als %d\r\n", iGuess);
        } while (iSecret!=iGuess);

        pc.puts("\r\nGratuliere!!! --> ");
        pc.printf("%d stimmt.\r\nMit 'e' beenden; jede andere Taste startet einen neuen Ratedurchgang\r\n", iGuess);
        if (pc.getc() == 'e')
            break;
    }
}
