#include "mbed.h"
#include "C12832_lcd.h"

// Erfassung von 2 analogen Eingaengen (poti1 und 2)
/*
a) Ermittelung der Werte mit 2 Hz (aktuelle Werte)
b) Umrechnung der Rohwerte (0.0 bis 1.0, oder 0 - 65535) in die physikalische Groesse Spannung
c) Berechnung des gleitenden Mittelwertes ueber die letzten 10 erfassten Werte
d) Ausgabe des aktuellen Wertes und des gleitend ermittelten Mittelwertes am LCD
   
Vertiefung 1:
Ausgabe als Balkengrafik (Bar Graph)

Vertiefung 2: 
Erstellen einer Klasse:
1) für gleitende Mittelwertbildung (Uebergabe der Array-Länge, Sample-Rate, Ermitteln des MW)
2) gleitende Mittelwertbildung (Uebergabe der Array-Länge, Sample-Rate, Ermitteln des MW, Min- und Maxwert)
3) gleitende Mittelwertbildung (Uebergabe des Array-Länge, Sample-Rate, Ermitteln des MW, Min- und Maxwert)
   Mittelwertbildung wird ohne den groessten und kleinsten Wert durchgeführt
   (2 und 3 auch als Überladung möglich)
*/

AnalogIn aiPoti1(p19);
C12832_LCD lcd;

int main() 
{
    float poti1Wert;
    lcd.cls();              // löscht den LCD
    lcd.locate(0,0);        // x-Postion, y-Position (x:0-128; y: 0-32)
    lcd.printf("Wert von Poti 1:");
    while(1) 
    {
       lcd.locate(0,10);
       poti1Wert = aiPoti1.read();
       lcd.printf("Spannung 1 = %5.3f V", poti1Wert*3.3);
       lcd.fillrect(0, 20, (int) (poti1Wert*128), 28, 1);     // Zeigt einen Balken am LCD Display an
       lcd.fillrect((int)(poti1Wert*128), 20, 128, 28, 0);
       lcd.copy_to_lcd();
       wait_ms(100);
    }
}
