
#include "mbed.h"
#include "Serial_HL.h"
#include "Bertl14.h"
#include "BertlObjects.h"

//              main=2^0  LS    ENC 2^2
BusOut boardPow(p30,      P1_6, P1_7);
Timer t1, t2;
AnalogInHL ls1(p18), ls2(p16), ls3(p20), ls4(p19), ls5(p17);

void FollowUntilEnd ();
void TurnUntilLine();
int main(void)
{
    pex.WaitUntilFrontButtonPressed();
    boardPow=3;
    wait_ms(10);
    InitBertl();
    pex.useISR=0;
    leds=9;
    pex.ClearLeds();
    t1.start();
    while(1)
    {
    wait_ms(1000);
    FollowUntilEnd ();
    wait_ms(1000);
    TurnUntilLine();
    }
    while(1){}


    return 1;
}

void FollowUntilEnd ()
{
    t1.reset();
    while(1) {


        if (ls3.Read()>400) {
            mL.SetPow(0.0);
            mR.SetPow(0.25);
            t1.reset();
        }

        else {
            mL.SetPow(0.25);
            mR.SetPow(0.0);
        }

        if (t1.read_ms()>500) {
            mL.SetPow(0.0);
            mR.SetPow(0.0);
            return;

        }

    }

}

void TurnUntilLine()
{
    mL.SetPow2(0.15);
    mR.SetPow2(-0.15);
    
    while(1){
    
    if (ls3.Read()>400){
        mL.SetPow2(0.0);
        mR.SetPow2(0.0);
        return;
        }
    }
    }