#include "mbed.h"
#include "C12832_lcd.h"

C12832_LCD lcd;
PwmOut led(LED1);

InterruptIn iiDown(p12);
DigitalIn diDown(p12);

InterruptIn iiUp(p15);
DigitalIn diUp(p15);

float brightness=0.0;

uint8_t debounce(DigitalIn myIn)
{
#define LEVEL_CHECKS 132
#define MAX_LOOPS 36              // stoppt das Überprüfen des Prellen nach max. MAX_LOOPS Durchläufen
    unsigned char port_buffer;
    unsigned char debounceCounter = 0;
    uint8_t loopCounter = 0;

    do {
        port_buffer = myIn;
        wait_us(500);
        loopCounter++;
        if(myIn == port_buffer)
            debounceCounter++;    // mindestens 'LEVEL_CHECKS' Abtastungen in Folge: gleicher Pegel
        else
            debounceCounter = 0;
    } while ((debounceCounter <= LEVEL_CHECKS) && (loopCounter <= MAX_LOOPS));
    return loopCounter;
}

void bightnessUP()
{
   debounce(diUp);
   brightness += 0.1; led = brightness; 
}

void bightnessDOWN()
{   
    debounce(diDown);
   brightness -= 0.1; led = brightness; 
}

void init ()
{
    iiUp.rise(&bightnessUP);
    iiDown.rise(&bightnessDOWN);
   
}

void abschalten()
{
    lcd.cls();
    lcd.locate(0,0);
    lcd.printf("SNT abschalten !!");
    
}
int main()
{
    
 

    while(true) {
        init();
        if (brightness>=0.8) {
            abschalten ();
        }
        if (brightness<=0.8) {
            lcd.cls();
        }
    }
}




