
#include "mbed.h"
#include "FahrradLeuchte.h"

//        LSB                                                      MSB
BusOut lb(P1_7,P1_6,P1_4,P1_3,P1_1,P1_0,LED4,LED3,LED2,LED1);

// Statusled zeigt uns in welchen Zustand die Statemachine gerade ist
BusOut stLED(P1_13, P1_12);

// BtnEventM0 erledigt für uns die Abfrage der positiven Flanke
BtnEventM0 sw4(P1_16), sw3(P0_23);
// sw4 == forward    sw3 == backward

class FahrradLeuchte
{
    public:
        void Init()
        {
            state=1; t1.start();
        }
        void State1Func(); 
        void State2Func();
        void State3Func();  
    public:     
        void State1Action();
        void State2Action();
        void State3Action();
    public:
        int state;  // state sagt uns in welchen Zustand die Fahrradleuchte gerade ist
        Timer t1;
};

FahrradLeuchte f1;

int main(void)
{
    sw4.Init(); sw3.Init(); f1.Init();
    while(1) 
    {
        if (f1.state==1)
            f1.State1Func();
        if (f1.state==2)
            f1.State2Func();
        if (f1.state==3)
            f1.State3Func();   
    }
}

void FahrradLeuchte::State1Func()
{
    //Einmalige Aktion in der der Zustandsfunktion
    stLED = 1; // Anzeigen dass wir im Zustand 1 sind
    t1.reset();   
    while (1)
    {
        State1Action();
        if (sw4.CheckFlag())
        {    
            state=2;
            return;
        }
        if (sw3.CheckFlag())
        {
            state=3;
            return;   
        }    
    }
}

void FahrradLeuchte::State1Action()
{
    // 2Hz blinken
    if (t1.read_ms()>500)
    {
        t1.reset();
        if (lb==0)
            lb = 0xFFFF;
        else
            lb = 0;    
    } 
}

void FahrradLeuchte::State2Func()
{
    stLED = 2; // Anzeigen dass wir im Zustand 1 sind
    t1.reset();   
    while (1)
    {
        State2Action();
        if (sw4.CheckFlag())
        {    
            state=3;
            return;
        }
        if (sw3.CheckFlag())
        {
            state=1;
            return;   
        }    
    }
}

void FahrradLeuchte::State2Action()
{
    // Runlight Left 5Hz
    // 2Hz blinken
    if (t1.read_ms()>200)
    {
        t1.reset();
        if (lb==0)
            lb = 0xFFFF;
        else
            lb = 0;    
    } 
}

void FahrradLeuchte::State3Func()
{
    stLED = 3; // Anzeigen dass wir im Zustand 1 sind
    t1.reset();   
    while (1)
    {
        State3Action();
        if (sw4.CheckFlag())
        {    
            state=1;
            return;
        }
        if (sw3.CheckFlag())
        {
            state=2;
            return;   
        }    
    }
}

void FahrradLeuchte::State3Action()
{
   // Runlight Right 10Hz
   // 2Hz blinken
    if (t1.read_ms()>100)
    {
        t1.reset();
        if (lb==0)
            lb = 0xFFFF;
        else
            lb = 0;    
    } 
}
