#include "mbed.h"
#include "BtnEventM0.h"

//        LSB                                           MSB
BusOut lb(P1_7,P1_6,P1_4,P1_3,P1_1,P1_0,LED4,LED3,LED2,LED1);

// Statusled zeigt uns in welchen Zustand die Statemachine gerade ist
BusOut stLED(P1_13, P1_12);

// BtnEventM0 erledigt für uns die Abfrage der positiven Flanke
BtnEventM0 sw4(P1_16), sw3(P0_23);

Serial pc(USBTX, USBRX);

const  int ST_ROT = 1;
const  int ST_GELB = 2;
const  int ST_GRUEN = 3;

class Ampel
{
    public:
        void Init()
        {
            state=ST_ROT; t1.start(); t2.start(); t3.start();  
        }
        void ROT();
        void GELB();
        void GRUEN();
        void GRUEN_BLINKEN();
    public:
        void RotAction();
        void GelbAction();
        void GruenAction();
        void GruenBlinkAction();
    public:
        int state;
        Timer t1;   // blinken
        Timer t2;   // mit 10Hz Daten zur Anzeige schicken
        Timer t3;   // Zeit bis zum umschalten ausmessen
};

Ampel amp;      // Objekt anlegen

int main(void) 
{
    amp.Init();
    sw4.Init(); sw3.Init();
    pc.baud(125000);
    while(1) 
    {
        if (amp.state==1)
            amp.ROT();
        if (amp.state==2)
            amp.GELB();
        if (amp.state==3)
            amp.GRUEN();      
    }
}

void Ampel::ROT()
{
    // Einmalige Eintrittsaktion
    // Zustand am Display anzeigen
    pc.printf("ROT\n");
    t3.reset();
    while (1)
    {
        if(t3.read_ms()>3000)
        {
            state=ST_GELB;
            return;  
        } 
        RotAction();
    }    
}

void Ampel::RotAction()
{
    // Blinken
    if(t1.read_ms()>500)
    {
        t1.reset();
        if(lb==0)
            lb=1;   // bei Gelb soll dann lb4
        else
            lb=0;
    } 
    //Restzeit mit 10Hz zur Anzeige senden
    if(t2.read_ms()>100)
    {
        t2.reset();
        pc.printf("2 %d\n", t3.read_ms()/100);    // Zeitanzeige auf 1/10 Sec genau
    }  
}

void Ampel::GELB()
{
    // Einmalige Eintrittsaktion
    // Zustand am Display anzeigen
    pc.printf("GELB\n");
    t3.reset();
    while (1)
    {
        if(t3.read_ms()>3000)
        {
            state=ST_GRUEN;
            return;  
        } 
        GelbAction();
        if (sw4.CheckFlag())
        {    
            state=ST_ROT;
            return;
        }
    }    
}

void Ampel::GelbAction()
{
    // Blinken
    if(t1.read_ms()>250)
    {
        t1.reset();
        if(lb==0)
            lb=4;   
        else
            lb=0;
    } 
    //Restzeit mit 10Hz zur Anzeige senden
    if(t2.read_ms()>100)
    {
        t2.reset();
        pc.printf("2 %d\n", t3.read_ms()/100);    // Zeitanzeige auf 1/10 Sec genau
    }  
}

void Ampel::GRUEN()
{
    // Einmalige Eintrittsaktion
    // Zustand am Display anzeigen
    pc.printf("GRUEN\n");
    t3.reset();
    while (1)
    {
        if(t3.read_ms()>3000)
        {
            state=ST_ROT;
            return;  
        } 
        GruenAction();
        if (sw4.CheckFlag())
        {    
            state=ST_ROT;
            return;
        }
    }    
}
void Ampel::GruenAction()
{
    // Blinken
    if(t1.read_ms()>100)
    {
        t1.reset();
        if(lb==0)
            lb=16;   
        else
            lb=0;
    } 
    //Restzeit mit 10Hz zur Anzeige senden
    if(t2.read_ms()>100)
    {
        t2.reset();
        pc.printf("2 %d\n", t3.read_ms()/100);    // Zeitanzeige auf 1/10 Sec genau
    }  
}